/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.knn;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.dataset.primitive.context.EmptyContext;
import org.apache.ignite.ml.environment.LearningEnvironment;
import org.apache.ignite.ml.knn.utils.indices.ArraySpatialIndex;
import org.apache.ignite.ml.knn.utils.indices.BallTreeSpatialIndex;
import org.apache.ignite.ml.knn.utils.indices.KDTreeSpatialIndex;
import org.apache.ignite.ml.knn.utils.indices.SpatialIndex;
import org.apache.ignite.ml.knn.utils.indices.SpatialIndexType;
import org.apache.ignite.ml.math.distances.DistanceMeasure;
import org.apache.ignite.ml.preprocessing.Preprocessor;

public class KNNPartitionDataBuilder<K, V>
implements PartitionDataBuilder<K, V, EmptyContext, SpatialIndex<Double>> {
    private final Preprocessor<K, V> preprocessor;
    private final SpatialIndexType spatialIdxType;
    private final DistanceMeasure distanceMeasure;

    public KNNPartitionDataBuilder(Preprocessor<K, V> preprocessor, SpatialIndexType spatialIdxType, DistanceMeasure distanceMeasure) {
        this.preprocessor = preprocessor;
        this.spatialIdxType = spatialIdxType;
        this.distanceMeasure = distanceMeasure;
    }

    @Override
    public SpatialIndex<Double> build(LearningEnvironment env, Iterator<UpstreamEntry<K, V>> upstreamData, long upstreamDataSize, EmptyContext ctx) {
        ArrayList dataPnts = new ArrayList();
        while (upstreamData.hasNext()) {
            UpstreamEntry<K, V> entry = upstreamData.next();
            dataPnts.add(this.preprocessor.apply(entry.getKey(), entry.getValue()));
        }
        switch (this.spatialIdxType) {
            case ARRAY: {
                return new ArraySpatialIndex<Double>(dataPnts, this.distanceMeasure);
            }
            case KD_TREE: {
                return new KDTreeSpatialIndex<Double>(dataPnts, this.distanceMeasure);
            }
            case BALL_TREE: {
                return new BallTreeSpatialIndex<Double>(dataPnts, this.distanceMeasure);
            }
        }
        throw new IllegalArgumentException("Unknown spatial index type [type=" + (Object)((Object)this.spatialIdxType) + "]");
    }
}

