/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.inference.storage.model;

import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.ml.inference.storage.model.FileOrDirectory;
import org.apache.ignite.ml.inference.storage.model.ModelStorageProvider;

public class LocalModelStorageProvider
implements ModelStorageProvider {
    private final ConcurrentMap<String, FileOrDirectory> storage = new ConcurrentHashMap<String, FileOrDirectory>();
    private final ConcurrentMap<String, WeakReference<Lock>> locks = new ConcurrentHashMap<String, WeakReference<Lock>>();

    @Override
    public FileOrDirectory get(String key) {
        return (FileOrDirectory)this.storage.get(key);
    }

    @Override
    public void put(String key, FileOrDirectory file) {
        this.storage.put(key, file);
    }

    @Override
    public void remove(String key) {
        this.storage.remove(key);
    }

    @Override
    public Lock lock(String key) {
        ReentrantLock lock = new ReentrantLock();
        return (Lock)this.locks.computeIfAbsent(key, k -> new WeakReference<Lock>(lock)).get();
    }
}

