/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.genetic.functions;

import java.sql.SQLException;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.ml.genetic.Chromosome;
import org.apache.ignite.ml.genetic.Gene;
import org.apache.ignite.ml.genetic.utils.GAGridUtils;
import org.gridgain.internal.h2.tools.SimpleResultSet;

public class GAGridFunction {
    @QuerySqlFunction
    public static SimpleResultSet getSolutionsDesc() {
        return GAGridFunction.getChromosomes("order by fitnessScore desc");
    }

    @QuerySqlFunction
    public static SimpleResultSet getSolutionsAsc() throws SQLException {
        return GAGridFunction.getChromosomes("order by fitnessScore asc");
    }

    @QuerySqlFunction
    public static SimpleResultSet getSolutionById(int key) throws SQLException {
        StringBuffer sbSqlClause = new StringBuffer();
        sbSqlClause.append("_key IN");
        sbSqlClause.append("(");
        sbSqlClause.append(key);
        sbSqlClause.append(")");
        return GAGridFunction.getChromosomes(sbSqlClause.toString());
    }

    private static SimpleResultSet getChromosomes(String qry) {
        Ignite ignite = Ignition.localIgnite();
        List<Chromosome> chromosomes = GAGridUtils.getChromosomes(ignite, qry);
        SimpleResultSet rs2 = new SimpleResultSet();
        Chromosome aChrom = chromosomes.get(0);
        int genesCnt = aChrom.getGenes().length;
        rs2.addColumn("Chromosome Id", 4, 0, 0);
        rs2.addColumn("Fitness Score", 8, 0, 0);
        for (int i = 0; i < genesCnt; ++i) {
            int colIdx = i + 1;
            rs2.addColumn("Gene " + colIdx, 12, 0, 0);
        }
        for (Chromosome rowChrom : chromosomes) {
            Object[] row = new Object[genesCnt + 2];
            row[0] = rowChrom.id();
            row[1] = rowChrom.getFitnessScore();
            List<Gene> genes = GAGridUtils.getGenesInOrderForChromosome(ignite, rowChrom);
            int i = 2;
            for (Gene gene : genes) {
                row[i] = gene.getVal().toString();
                ++i;
            }
            rs2.addRow(row);
        }
        return rs2;
    }
}

