/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.composition.combinators.parallel;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.ml.IgniteModel;

public final class ModelsParallelComposition<I, O>
implements IgniteModel<I, List<O>> {
    private final List<IgniteModel<I, O>> submodels;

    public ModelsParallelComposition(List<IgniteModel<I, O>> submodels) {
        this.submodels = submodels;
    }

    @Override
    public List<O> predict(I i) {
        return this.submodels.stream().map(m -> m.predict(i)).collect(Collectors.toList());
    }

    public List<IgniteModel<I, O>> submodels() {
        return Collections.unmodifiableList(this.submodels);
    }

    @Override
    public void close() {
        this.submodels.forEach(IgniteModel::close);
    }
}

