/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.util.generators.primitives.vector;

import java.io.Serializable;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.VectorUtils;
import org.apache.ignite.ml.util.generators.primitives.scalar.GaussRandomProducer;
import org.apache.ignite.ml.util.generators.primitives.scalar.RandomProducer;
import org.apache.ignite.ml.util.generators.primitives.scalar.UniformRandomProducer;
import org.apache.ignite.ml.util.generators.primitives.vector.ParametricVectorGenerator;
import org.apache.ignite.ml.util.generators.primitives.vector.VectorGenerator;

public class VectorGeneratorPrimitives {
    public static VectorGenerator gauss(Vector means, Vector variances, Long seed) {
        A.notEmpty((double[])means.asArray(), (String)"mean.size() != 0");
        A.ensure((means.size() == variances.size() ? 1 : 0) != 0, (String)"mean.size() == variances.size()");
        RandomProducer[] producers = new RandomProducer[means.size()];
        for (int i = 0; i < producers.length; ++i) {
            seed = seed * 2L;
            producers[i] = new GaussRandomProducer(means.get(i), variances.get(i), seed);
        }
        return RandomProducer.vectorize(producers);
    }

    public static VectorGenerator gauss(Vector means, Vector variances) {
        return VectorGeneratorPrimitives.gauss(means, variances, System.currentTimeMillis());
    }

    public static VectorGenerator ring(double radius, double fromAngle, double toAngle) {
        return VectorGeneratorPrimitives.ring(radius, fromAngle, toAngle, System.currentTimeMillis());
    }

    public static VectorGenerator ring(double radius, double fromAngle, double toAngle, long seed) {
        return new ParametricVectorGenerator(new UniformRandomProducer(fromAngle, toAngle, seed), t -> radius * Math.sin(t), t -> radius * Math.cos(t));
    }

    public static VectorGenerator parallelogram(Vector bounds) {
        return VectorGeneratorPrimitives.parallelogram(bounds, System.currentTimeMillis());
    }

    public static VectorGenerator parallelogram(Vector bounds, long seed) {
        A.ensure((bounds.size() != 0 ? 1 : 0) != 0, (String)"bounds.size() != 0");
        RandomProducer[] producers = new UniformRandomProducer[bounds.size()];
        for (int i = 0; i < producers.length; ++i) {
            producers[i] = new UniformRandomProducer(-bounds.get(i), bounds.get(i), seed *= 2L);
        }
        return RandomProducer.vectorize(producers);
    }

    public static VectorGenerator circle(double radius) {
        return VectorGeneratorPrimitives.circle(radius, System.currentTimeMillis());
    }

    public static VectorGenerator circle(double radius, long seed) {
        return new UniformRandomProducer(-radius, radius, seed).vectorize(2).filter((IgnitePredicate<Vector>)(IgnitePredicate & Serializable)v -> Math.sqrt(v.getLengthSquared()) <= radius);
    }

    public static VectorGenerator zero(int size) {
        return VectorGeneratorPrimitives.constant(VectorUtils.zeroes(size));
    }

    public static VectorGenerator constant(Vector v) {
        return () -> v;
    }
}

