/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.split;

import java.io.Serializable;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.ml.selection.split.TrainTestSplit;
import org.apache.ignite.ml.selection.split.mapper.SHA256UniformMapper;
import org.apache.ignite.ml.selection.split.mapper.UniformMapper;

public class TrainTestDatasetSplitter<K, V>
implements Serializable {
    private static final long serialVersionUID = 3148338796945474491L;
    private final UniformMapper<K, V> mapper;

    public TrainTestDatasetSplitter() {
        this(new SHA256UniformMapper());
    }

    public TrainTestDatasetSplitter(UniformMapper<K, V> mapper) {
        this.mapper = mapper;
    }

    public TrainTestSplit<K, V> split(double trainSize) {
        return this.split(trainSize, 1.0 - trainSize);
    }

    public TrainTestSplit<K, V> split(double trainSize, double testSize) {
        return new TrainTestSplit(new DatasetSplitFilter(this.mapper, 0.0, trainSize), new DatasetSplitFilter(this.mapper, trainSize, trainSize + testSize));
    }

    class DatasetSplitFilter
    implements IgniteBiPredicate<K, V> {
        private static final long serialVersionUID = 2247757751655582254L;
        private final UniformMapper<K, V> mapper;
        private final double from;
        private final double to;

        DatasetSplitFilter(UniformMapper<K, V> mapper, double from, double to) {
            assert (from >= 0.0 && from <= 1.0) : "Point 'from' should be in interval (0, 1)";
            assert (to >= 0.0 && to <= 1.0) : "Point 'to' should be in interval (0, 1)";
            assert (from <= to) : "Point 'from' should be less of equal to point 'to'";
            this.mapper = mapper;
            this.from = from;
            this.to = to;
        }

        public boolean apply(K key, V val) {
            double pnt = this.mapper.map(key, val);
            assert (pnt >= 0.0 && pnt <= 1.0) : "Point should be in interval (0, 1)";
            return pnt >= this.from && pnt < this.to;
        }
    }
}

