/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.primitives.vector.impl;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.ignite.ml.math.StorageConstants;
import org.apache.ignite.ml.math.primitives.matrix.Matrix;
import org.apache.ignite.ml.math.primitives.matrix.impl.SparseMatrix;
import org.apache.ignite.ml.math.primitives.vector.AbstractVector;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.storage.SparseVectorStorage;

public class SparseVector
extends AbstractVector
implements StorageConstants {
    public SparseVector() {
    }

    public SparseVector(Map<Integer, Double> map, boolean cp) {
        this.setStorage(new SparseVectorStorage(map, cp));
    }

    public SparseVector(int size) {
        this.setStorage(new SparseVectorStorage(size));
    }

    private SparseVectorStorage storage() {
        return (SparseVectorStorage)this.getStorage();
    }

    @Override
    public Vector like(int crd) {
        return new SparseVector(crd);
    }

    @Override
    public Matrix likeMatrix(int rows, int cols) {
        return new SparseMatrix(rows, cols);
    }

    @Override
    public Vector times(double x) {
        if (x == 0.0) {
            return this.assign(0.0);
        }
        return super.times(x);
    }

    public IntSet indexes() {
        return this.storage().indexes();
    }

    @Override
    public Spliterator<Double> nonZeroSpliterator() {
        return new Spliterator<Double>(){

            @Override
            public boolean tryAdvance(Consumer<? super Double> act) {
                IntSet indexes = SparseVector.this.storage().indexes();
                for (Integer index : indexes) {
                    act.accept((Double)SparseVector.this.storageGet(index));
                }
                return true;
            }

            @Override
            public Spliterator<Double> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return SparseVector.this.storage().indexes().size();
            }

            @Override
            public int characteristics() {
                return 80;
            }
        };
    }
}

