/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.inference.storage.model.thinclient;

import java.util.Arrays;
import java.util.Set;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.internal.processors.platform.client.ClientBooleanResponse;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.CustomQueryProcessor;
import org.apache.ignite.ml.inference.storage.model.ModelStorage;
import org.apache.ignite.ml.inference.storage.model.thinclient.FileRespose;
import org.apache.ignite.ml.inference.storage.model.thinclient.FileStatResponse;
import org.apache.ignite.ml.inference.storage.model.thinclient.FilesListResponse;

public class ModelStorateThinClientProcessor
implements CustomQueryProcessor {
    public static final String PROCESSOR_ID = "ML_MODEL_STORAGE";
    private final ModelStorage modelStorage;

    public ModelStorateThinClientProcessor(ModelStorage modelStorage) {
        this.modelStorage = modelStorage;
    }

    public ClientResponse call(long requestId, byte methodId, BinaryRawReader reader) {
        Method op = Method.find(methodId);
        if (op == null) {
            return this.error(requestId, "Operation was not found [id=" + methodId + "]");
        }
        switch (op) {
            case WRITE_FILE: {
                return this.writeFile(requestId, reader);
            }
            case READ_FILE: {
                return this.readFile(requestId, reader);
            }
            case MOVE: {
                return this.moveFile(requestId, reader);
            }
            case STAT: {
                return this.getFileStat(requestId, reader);
            }
            case EXISTS: {
                return this.isExists(requestId, reader);
            }
            case REMOVE: {
                return this.remove(requestId, reader);
            }
            case MKDIR: {
                return this.mkdir(requestId, reader);
            }
            case MKDIRS: {
                return this.mkdirs(requestId, reader);
            }
            case LIST_FILES: {
                return this.listFiles(requestId, reader);
            }
        }
        throw new IllegalArgumentException("Cannot find handler for operation [id=" + op.name() + "]");
    }

    private ClientResponse writeFile(long reqId, BinaryRawReader reader) {
        String path = reader.readString();
        return this.modelStorage.lockPaths(() -> {
            boolean create = reader.readBoolean();
            boolean append = reader.readBoolean();
            byte[] newData = reader.readByteArray();
            boolean fileAlreadyExists = this.modelStorage.exists(path);
            if (!create && !fileAlreadyExists) {
                return this.error(reqId, "File doesn't exist [path=" + path + "]");
            }
            byte[] currentData = new byte[]{};
            if (fileAlreadyExists) {
                if (append && !create) {
                    currentData = this.modelStorage.getFile(path);
                }
                this.modelStorage.remove(path);
            }
            byte[] result = new byte[currentData.length + newData.length];
            System.arraycopy(currentData, 0, result, 0, currentData.length);
            System.arraycopy(newData, 0, result, currentData.length, newData.length);
            this.modelStorage.putFile(path, result);
            return new ClientResponse(reqId);
        }, path);
    }

    private ClientResponse readFile(long reqId, BinaryRawReader reader) {
        String path = reader.readString();
        return this.modelStorage.lockPaths(() -> {
            if (!this.modelStorage.exists(path)) {
                return this.error(reqId, "File not found [path=" + path + "]");
            }
            if (!this.modelStorage.isFile(path)) {
                return this.error(reqId, "File is not regular file [path" + path + "]");
            }
            return new FileRespose(reqId, this.modelStorage.getFile(path));
        }, path);
    }

    private ClientResponse moveFile(long reqId, BinaryRawReader reader) {
        String from = reader.readString();
        String to = reader.readString();
        String[] pathsToLock = new String[]{from, to};
        Arrays.sort(pathsToLock, (s1, s2) -> {
            if (s1.length() == s2.length()) {
                return s1.compareTo((String)s2);
            }
            return Integer.compare(s1.length(), s2.length());
        });
        return this.modelStorage.lockPaths(() -> {
            if (!this.modelStorage.exists(from)) {
                return this.error(reqId, "File not found [path=" + from + "]");
            }
            if (this.modelStorage.exists(to)) {
                return this.error(reqId, "File already exists [path=" + to + "]");
            }
            if (!this.modelStorage.isFile(from)) {
                return this.error(reqId, "File is not regular file [path=" + from + "]");
            }
            byte[] file = this.modelStorage.getFile(from);
            this.modelStorage.remove(from);
            this.modelStorage.putFile(to, file);
            return new ClientResponse(reqId);
        }, pathsToLock);
    }

    private ClientResponse getFileStat(long reqId, BinaryRawReader reader) {
        String path = reader.readString();
        return this.modelStorage.lockPaths(() -> {
            if (!this.modelStorage.exists(path)) {
                return this.error(reqId, "File not found [path=" + path + "]");
            }
            return new FileStatResponse(reqId, this.modelStorage.getFileStat(path));
        }, path);
    }

    private ClientResponse isExists(long reqId, BinaryRawReader reader) {
        String path = reader.readString();
        return new ClientBooleanResponse(reqId, this.modelStorage.exists(path));
    }

    private ClientResponse remove(long reqId, BinaryRawReader reader) {
        String path = reader.readString();
        return this.modelStorage.lockPaths(() -> {
            if (this.modelStorage.exists(path)) {
                try {
                    this.modelStorage.remove(path);
                }
                catch (IllegalArgumentException e) {
                    return this.error(reqId, "Cannot delete non-empty directory [path= " + path + "]");
                }
            }
            return new ClientResponse(reqId);
        }, path);
    }

    private ClientResponse mkdir(long reqId, BinaryRawReader reader) {
        String path = reader.readString();
        boolean onlyIfNotExists = reader.readBoolean();
        return this.modelStorage.lockPaths(() -> {
            if (onlyIfNotExists && this.modelStorage.exists(path)) {
                return this.error(reqId, "Directory already exists [path=" + path + "]");
            }
            this.modelStorage.mkdir(path, onlyIfNotExists);
            return new ClientResponse(reqId);
        }, path);
    }

    private ClientResponse mkdirs(long reqId, BinaryRawReader reader) {
        String path = reader.readString();
        boolean onlyIfNotExists = reader.readBoolean();
        return this.modelStorage.lockPaths(() -> {
            if (onlyIfNotExists && this.modelStorage.exists(path)) {
                return this.error(reqId, "Directory already exists [path=" + path + "]");
            }
            this.modelStorage.mkdirs(path);
            return new ClientResponse(reqId);
        }, path);
    }

    private ClientResponse listFiles(long reqId, BinaryRawReader reader) {
        String path = reader.readString();
        return this.modelStorage.lockPaths(() -> {
            if (!this.modelStorage.exists(path)) {
                return this.error(reqId, "Direcrory not found [path=" + path + "]");
            }
            if (this.modelStorage.isFile(path)) {
                return this.error(reqId, "Specified path is not associated with directory [path=" + path + "]");
            }
            Set<String> files = this.modelStorage.listFiles(path);
            return new FilesListResponse(reqId, files);
        }, path);
    }

    private ClientResponse error(long requestId, String msg) {
        return new ClientResponse(requestId, msg);
    }

    public String id() {
        return PROCESSOR_ID;
    }

    public static enum Method {
        WRITE_FILE(0),
        READ_FILE(1),
        MOVE(2),
        STAT(3),
        EXISTS(4),
        REMOVE(5),
        MKDIR(6),
        MKDIRS(7),
        LIST_FILES(8);

        private final int id;

        private Method(int id) {
            this.id = id;
        }

        static Method find(int id) {
            for (Method op : Method.values()) {
                if (op.id != id) continue;
                return op;
            }
            return null;
        }

        public byte id() {
            return (byte)this.id;
        }
    }
}

