/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset.impl.cache.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

class PartitionDataStorage
implements AutoCloseable {
    private final ConcurrentMap<Integer, ObjectWithUsageStat> storage = new ConcurrentHashMap<Integer, ObjectWithUsageStat>();
    private final ConcurrentMap<Integer, Lock> locks = new ConcurrentHashMap<Integer, Lock>();
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
    private final long ttl;

    public PartitionDataStorage(long ttl) {
        this.ttl = ttl * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <D> D computeDataIfAbsent(int part, Supplier<D> supplier) {
        ObjectWithUsageStat objWithStat = (ObjectWithUsageStat)this.storage.get(part);
        if (objWithStat == null) {
            Lock lock = this.locks.computeIfAbsent(part, p -> new ReentrantLock());
            lock.lock();
            try {
                objWithStat = (ObjectWithUsageStat)this.storage.get(part);
                if (objWithStat == null) {
                    objWithStat = new ObjectWithUsageStat(supplier.get());
                    this.storage.put(part, objWithStat);
                    if (this.ttl > -1L) {
                        this.executor.schedule(new Cleaner(part), this.ttl, TimeUnit.MILLISECONDS);
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
        objWithStat.updateLastAccessTime();
        return (D)objWithStat.data;
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }

    private class ObjectWithUsageStat
    implements AutoCloseable {
        private final Object data;
        private volatile long lastAccessTime;

        ObjectWithUsageStat(Object data) {
            this.data = data;
        }

        void updateLastAccessTime() {
            this.lastAccessTime = System.currentTimeMillis();
        }

        boolean isExpired() {
            return this.lastAccessTime + PartitionDataStorage.this.ttl <= System.currentTimeMillis();
        }

        @Override
        public void close() {
            if (this.data instanceof AutoCloseable) {
                AutoCloseable closeableData = (AutoCloseable)this.data;
                try {
                    closeableData.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private class Cleaner
    implements Runnable {
        private final int part;

        public Cleaner(int part) {
            this.part = part;
        }

        @Override
        public void run() {
            ObjectWithUsageStat objWithStat = (ObjectWithUsageStat)PartitionDataStorage.this.storage.get(this.part);
            if (objWithStat.isExpired()) {
                this.removeFromStorage();
                objWithStat.close();
            } else {
                this.reschedule(objWithStat.lastAccessTime);
            }
        }

        private void removeFromStorage() {
            PartitionDataStorage.this.storage.remove(this.part);
            PartitionDataStorage.this.locks.remove(this.part);
        }

        private void reschedule(long lastAccessTime) {
            long delay = lastAccessTime - System.currentTimeMillis() + PartitionDataStorage.this.ttl;
            PartitionDataStorage.this.executor.schedule(this, Math.max(0L, delay), TimeUnit.MILLISECONDS);
        }
    }
}

