/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.data;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.environment.LearningEnvironment;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.structures.LabeledVector;
import org.apache.ignite.ml.tree.data.DecisionTreeData;

public class DecisionTreeDataBuilder<K, V, C extends Serializable>
implements PartitionDataBuilder<K, V, C, DecisionTreeData> {
    private static final long serialVersionUID = 3678784980215216039L;
    private final Preprocessor<K, V> preprocessor;
    private final boolean buildIdx;

    public DecisionTreeDataBuilder(Preprocessor<K, V> preprocessor, boolean buildIdx) {
        this.preprocessor = preprocessor;
        this.buildIdx = buildIdx;
    }

    @Override
    public DecisionTreeData build(LearningEnvironment envBuilder, Iterator<UpstreamEntry<K, V>> upstreamData, long upstreamDataSize, C ctx) {
        double[][] features = new double[Math.toIntExact(upstreamDataSize)][];
        double[] labels = new double[Math.toIntExact(upstreamDataSize)];
        int ptr = 0;
        while (upstreamData.hasNext()) {
            UpstreamEntry<K, V> entry = upstreamData.next();
            LabeledVector featsAndLbl = (LabeledVector)this.preprocessor.apply(entry.getKey(), entry.getValue());
            features[ptr] = featsAndLbl.features().asArray();
            labels[ptr] = (Double)featsAndLbl.label();
            ++ptr;
        }
        return new DecisionTreeData(features, labels, this.buildIdx);
    }
}

