/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.preprocessing.maxabsscaling;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.ml.environment.deploy.DeployableObject;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.structures.LabeledVector;

public final class MaxAbsScalerPreprocessor<K, V>
implements Preprocessor<K, V>,
DeployableObject {
    private static final long serialVersionUID = 1L;
    private final double[] maxAbs;
    private final Preprocessor<K, V> basePreprocessor;

    public MaxAbsScalerPreprocessor(double[] maxAbs, Preprocessor<K, V> basePreprocessor) {
        this.maxAbs = maxAbs;
        this.basePreprocessor = basePreprocessor;
    }

    @Override
    public LabeledVector apply(K k, V v) {
        LabeledVector res = (LabeledVector)this.basePreprocessor.apply(k, v);
        assert (res.size() == this.maxAbs.length);
        for (int i = 0; i < res.size(); ++i) {
            res.set(i, res.get(i) / this.maxAbs[i]);
        }
        return res;
    }

    public double[] getMaxAbs() {
        return this.maxAbs;
    }

    @Override
    public List<Object> getDependencies() {
        return Collections.singletonList(this.basePreprocessor);
    }
}

