/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.primitives.vector.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.IntToDoubleFunction;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.functions.IgniteDoubleFunction;
import org.apache.ignite.ml.math.functions.IgniteIntDoubleToDoubleBiFunction;
import org.apache.ignite.ml.math.primitives.matrix.Matrix;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.VectorStorage;

public class DelegatingVector
implements Vector {
    private Vector dlg;
    private Map<String, Object> meta = new HashMap<String, Object>();
    private IgniteUuid guid = IgniteUuid.randomUuid();

    public DelegatingVector() {
    }

    public DelegatingVector(Vector dlg) {
        assert (dlg != null);
        this.dlg = dlg;
    }

    public Vector getVector() {
        return this.dlg;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.dlg);
        out.writeObject(this.meta);
        out.writeObject(this.guid);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.dlg = (Vector)in.readObject();
        this.meta = (Map)in.readObject();
        this.guid = (IgniteUuid)in.readObject();
    }

    @Override
    public Map<String, Object> getMetaStorage() {
        return this.meta;
    }

    @Override
    public Matrix likeMatrix(int rows, int cols) {
        return this.dlg.likeMatrix(rows, cols);
    }

    @Override
    public Matrix toMatrix(boolean rowLike) {
        return this.dlg.toMatrix(rowLike);
    }

    @Override
    public Matrix toMatrixPlusOne(boolean rowLike, double zeroVal) {
        return this.dlg.toMatrixPlusOne(rowLike, zeroVal);
    }

    @Override
    public int size() {
        return this.dlg.size();
    }

    @Override
    public boolean isDense() {
        return this.dlg.isDense();
    }

    @Override
    public double minValue() {
        return this.dlg.minValue();
    }

    @Override
    public double maxValue() {
        return this.dlg.maxValue();
    }

    @Override
    public boolean isArrayBased() {
        return this.dlg.isArrayBased();
    }

    @Override
    public Vector copy() {
        return new DelegatingVector(this.dlg);
    }

    @Override
    public Iterable<Vector.Element> all() {
        return this.dlg.all();
    }

    @Override
    public Iterable<Vector.Element> nonZeroes() {
        return this.dlg.nonZeroes();
    }

    @Override
    public Vector sort() {
        return this.dlg.sort();
    }

    @Override
    public Vector copyOfRange(int from, int to) {
        return this.dlg.copyOfRange(from, to);
    }

    @Override
    public Spliterator<Double> allSpliterator() {
        return this.dlg.allSpliterator();
    }

    @Override
    public Spliterator<Double> nonZeroSpliterator() {
        return this.dlg.nonZeroSpliterator();
    }

    @Override
    public Vector.Element getElement(int idx) {
        return this.dlg.getElement(idx);
    }

    @Override
    public Vector assign(double val) {
        return this.dlg.assign(val);
    }

    @Override
    public Vector assign(double[] vals) {
        return this.dlg.assign(vals);
    }

    @Override
    public Vector assign(Vector vec) {
        return this.dlg.assign(vec);
    }

    @Override
    public Vector assign(IntToDoubleFunction fun) {
        return this.dlg.assign(fun);
    }

    @Override
    public Vector map(IgniteDoubleFunction<Double> fun) {
        return this.dlg.map(fun);
    }

    @Override
    public Vector map(Vector vec, IgniteBiFunction<Double, Double, Double> fun) {
        return this.dlg.map(vec, fun);
    }

    @Override
    public Vector map(IgniteBiFunction<Double, Double, Double> fun, double y) {
        return this.dlg.map(fun, y);
    }

    @Override
    public Vector divide(double x) {
        return this.dlg.divide(x);
    }

    @Override
    public double dot(Vector vec) {
        return this.dlg.dot(vec);
    }

    @Override
    public double get(int idx) {
        return this.dlg.get(idx);
    }

    @Override
    public double getX(int idx) {
        return this.dlg.getX(idx);
    }

    @Override
    public <T extends Serializable> T getRaw(int idx) {
        return this.dlg.getRaw(idx);
    }

    @Override
    public <T extends Serializable> T getRawX(int idx) {
        return this.dlg.getRawX(idx);
    }

    @Override
    public Vector like(int crd) {
        return this.dlg.like(crd);
    }

    @Override
    public Vector minus(Vector vec) {
        return this.dlg.minus(vec);
    }

    @Override
    public Vector normalize() {
        return this.dlg.normalize();
    }

    @Override
    public Vector normalize(double power) {
        return this.dlg.normalize(power);
    }

    @Override
    public Vector logNormalize() {
        return this.dlg.logNormalize();
    }

    @Override
    public Vector logNormalize(double power) {
        return this.dlg.logNormalize(power);
    }

    @Override
    public double kNorm(double power) {
        return this.dlg.kNorm(power);
    }

    @Override
    public Vector.Element minElement() {
        return this.dlg.minElement();
    }

    @Override
    public Vector.Element maxElement() {
        return this.dlg.maxElement();
    }

    @Override
    public Vector plus(double x) {
        return this.dlg.plus(x);
    }

    @Override
    public Vector plus(Vector vec) {
        return this.dlg.plus(vec);
    }

    @Override
    public Vector set(int idx, double val) {
        return this.dlg.set(idx, val);
    }

    @Override
    public Vector setX(int idx, double val) {
        return this.dlg.setX(idx, val);
    }

    @Override
    public Vector setRaw(int idx, Serializable val) {
        return this.dlg.setRaw(idx, val);
    }

    @Override
    public Vector setRawX(int idx, Serializable val) {
        return this.dlg.setRawX(idx, val);
    }

    @Override
    public Vector incrementX(int idx, double val) {
        return this.dlg.incrementX(idx, val);
    }

    @Override
    public Vector increment(int idx, double val) {
        return this.dlg.increment(idx, val);
    }

    @Override
    public int nonZeroElements() {
        return this.dlg.nonZeroElements();
    }

    @Override
    public Vector times(double x) {
        return this.dlg.times(x);
    }

    @Override
    public Vector times(Vector vec) {
        return this.dlg.times(vec);
    }

    @Override
    public Vector viewPart(int off, int len) {
        return this.dlg.viewPart(off, len);
    }

    @Override
    public VectorStorage getStorage() {
        return this.dlg.getStorage();
    }

    @Override
    public double sum() {
        return this.dlg.sum();
    }

    @Override
    public Matrix cross(Vector vec) {
        return this.dlg.cross(vec);
    }

    @Override
    public <T> T foldMap(IgniteBiFunction<T, Double, T> foldFun, IgniteDoubleFunction<Double> mapFun, T zeroVal) {
        return this.dlg.foldMap(foldFun, mapFun, zeroVal);
    }

    @Override
    public <T> T foldMap(Vector vec, IgniteBiFunction<T, Double, T> foldFun, IgniteBiFunction<Double, Double, Double> combFun, T zeroVal) {
        return this.dlg.foldMap(vec, foldFun, combFun, zeroVal);
    }

    @Override
    public double getLengthSquared() {
        return this.dlg.getLengthSquared();
    }

    @Override
    public double getDistanceSquared(Vector vec) {
        return this.dlg.getDistanceSquared(vec);
    }

    @Override
    public boolean isDistributed() {
        return this.dlg.isDistributed();
    }

    @Override
    public boolean isNumeric() {
        return this.dlg.isNumeric();
    }

    @Override
    public IgniteUuid guid() {
        return this.guid;
    }

    @Override
    public void compute(int i, IgniteIntDoubleToDoubleBiFunction f) {
        this.dlg.compute(i, f);
    }

    @Override
    public void destroy() {
        this.dlg.destroy();
    }

    public int hashCode() {
        int res = 1;
        res = res * 37 + this.meta.hashCode();
        res = res * 37 + this.dlg.hashCode();
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelegatingVector that = (DelegatingVector)o;
        return this.meta.equals(that.meta) && this.dlg.equals(that.dlg);
    }
}

