/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.knn.utils.indices;

import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.ignite.ml.knn.utils.PointWithDistanceUtil;
import org.apache.ignite.ml.knn.utils.indices.SpatialIndex;
import org.apache.ignite.ml.math.distances.DistanceMeasure;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.structures.LabeledVector;

public class ArraySpatialIndex<L>
implements SpatialIndex<L> {
    private final List<LabeledVector<L>> data;
    private final DistanceMeasure distanceMeasure;

    public ArraySpatialIndex(List<LabeledVector<L>> data, DistanceMeasure distanceMeasure) {
        this.data = Collections.unmodifiableList(data);
        this.distanceMeasure = distanceMeasure;
    }

    @Override
    public List<LabeledVector<L>> findKClosest(int k, Vector pnt) {
        if (k <= 0) {
            throw new IllegalArgumentException("Number of neighbours should be positive.");
        }
        PriorityQueue heap = new PriorityQueue(Collections.reverseOrder());
        for (LabeledVector<L> dataPnt : this.data) {
            double distance = this.distanceMeasure.compute(pnt, (Vector)dataPnt.features());
            PointWithDistanceUtil.tryToAddIntoHeap(heap, k, dataPnt, distance);
        }
        return PointWithDistanceUtil.transfomToListOrdered(heap);
    }
}

