/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.knn;

import org.apache.ignite.ml.dataset.Dataset;
import org.apache.ignite.ml.dataset.DatasetBuilder;
import org.apache.ignite.ml.dataset.primitive.builder.context.EmptyContextBuilder;
import org.apache.ignite.ml.dataset.primitive.context.EmptyContext;
import org.apache.ignite.ml.knn.KNNModel;
import org.apache.ignite.ml.knn.KNNPartitionDataBuilder;
import org.apache.ignite.ml.knn.utils.indices.SpatialIndex;
import org.apache.ignite.ml.knn.utils.indices.SpatialIndexType;
import org.apache.ignite.ml.math.distances.DistanceMeasure;
import org.apache.ignite.ml.math.distances.EuclideanDistance;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.trainers.SingleLabelDatasetTrainer;

public abstract class KNNTrainer<M extends KNNModel<Double>, Self extends KNNTrainer<M, Self>>
extends SingleLabelDatasetTrainer<M> {
    private SpatialIndexType idxType = SpatialIndexType.KD_TREE;
    protected DistanceMeasure distanceMeasure = new EuclideanDistance();
    protected int k = 5;
    protected boolean weighted;

    @Override
    protected <K, V> M fitWithInitializedDeployingContext(DatasetBuilder<K, V> datasetBuilder, Preprocessor<K, V> preprocessor) {
        return this.updateModel((M)null, datasetBuilder, preprocessor);
    }

    @Override
    public boolean isUpdateable(M mdl) {
        return true;
    }

    @Override
    protected <K, V> M updateModel(M mdl, DatasetBuilder<K, V> datasetBuilder, Preprocessor<K, V> preprocessor) {
        Dataset<EmptyContext, SpatialIndex<Double>> knnDataset = datasetBuilder.build(this.envBuilder, new EmptyContextBuilder(), new KNNPartitionDataBuilder<K, V>(preprocessor, this.idxType, this.distanceMeasure), this.learningEnvironment());
        return this.convertDatasetIntoModel(knnDataset);
    }

    protected abstract M convertDatasetIntoModel(Dataset<EmptyContext, SpatialIndex<Double>> var1);

    protected abstract Self self();

    public Self withIdxType(SpatialIndexType idxType) {
        this.idxType = idxType;
        return this.self();
    }

    public Self withDataTtl(long dataTtl) {
        this.envBuilder = this.envBuilder.withDataTtl(dataTtl);
        return this.self();
    }

    public Self withDistanceMeasure(DistanceMeasure distanceMeasure) {
        this.distanceMeasure = distanceMeasure;
        return this.self();
    }

    public Self withK(int k) {
        this.k = k;
        return this.self();
    }

    public Self withWeighted(boolean weighted) {
        this.weighted = weighted;
        return this.self();
    }
}

