/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset.impl.cache.util;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IteratorWithConcurrentModificationChecker<T>
implements Iterator<T> {
    private final Iterator<T> delegate;
    private long expCnt;
    private final String eMsg;

    public IteratorWithConcurrentModificationChecker(Iterator<T> delegate, long expCnt, String eMsg) {
        this.delegate = delegate;
        this.expCnt = expCnt;
        this.eMsg = eMsg;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.delegate.hasNext();
        if (!hasNext ^ this.expCnt == 0L) {
            throw new ConcurrentModificationException(this.eMsg);
        }
        return hasNext;
    }

    @Override
    public T next() {
        try {
            T next = this.delegate.next();
            if (this.expCnt == 0L) {
                throw new ConcurrentModificationException(this.eMsg);
            }
            --this.expCnt;
            return next;
        }
        catch (NoSuchElementException e) {
            if (this.expCnt == 0L) {
                throw e;
            }
            throw new ConcurrentModificationException(this.eMsg);
        }
    }
}

