/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.composition;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.ml.Exportable;
import org.apache.ignite.ml.Exporter;
import org.apache.ignite.ml.IgniteModel;
import org.apache.ignite.ml.composition.ModelsCompositionFormat;
import org.apache.ignite.ml.composition.predictionsaggregator.PredictionsAggregator;
import org.apache.ignite.ml.environment.deploy.DeployableObject;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.util.ModelTrace;

public class ModelsComposition
implements IgniteModel<Vector, Double>,
Exportable<ModelsCompositionFormat>,
DeployableObject {
    private final PredictionsAggregator predictionsAggregator;
    private final List<IgniteModel<Vector, Double>> models;

    public ModelsComposition(List<? extends IgniteModel<Vector, Double>> models, PredictionsAggregator predictionsAggregator) {
        this.predictionsAggregator = predictionsAggregator;
        this.models = Collections.unmodifiableList(models);
    }

    @Override
    public Double predict(Vector features) {
        double[] predictions = new double[this.models.size()];
        for (int i = 0; i < this.models.size(); ++i) {
            predictions[i] = (Double)this.models.get(i).predict(features);
        }
        return (Double)this.predictionsAggregator.apply(predictions);
    }

    public PredictionsAggregator getPredictionsAggregator() {
        return this.predictionsAggregator;
    }

    public List<IgniteModel<Vector, Double>> getModels() {
        return this.models;
    }

    @Override
    public <P> void saveModel(Exporter<ModelsCompositionFormat, P> exporter, P path) {
        ModelsCompositionFormat format = new ModelsCompositionFormat(this.models, this.predictionsAggregator);
        exporter.save(format, path);
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean pretty) {
        return ModelTrace.builder("Models composition", pretty).addField("aggregator", this.predictionsAggregator.toString(pretty)).addField("models", this.models).toString();
    }

    @Override
    public List<Object> getDependencies() {
        return Collections.singletonList(this.predictionsAggregator);
    }
}

