/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.composition;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.ml.IgniteModel;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.VectorUtils;
import org.apache.ignite.ml.util.ModelTrace;

public final class ModelOnFeaturesSubspace
implements IgniteModel<Vector, Double> {
    private final Map<Integer, Integer> featuresMapping;
    private final IgniteModel<Vector, Double> mdl;

    ModelOnFeaturesSubspace(Map<Integer, Integer> featuresMapping, IgniteModel<Vector, Double> mdl) {
        this.featuresMapping = Collections.unmodifiableMap(featuresMapping);
        this.mdl = mdl;
    }

    @Override
    public Double predict(Vector features) {
        double[] newFeatures = new double[this.featuresMapping.size()];
        this.featuresMapping.forEach((localId, featureVectorId) -> {
            newFeatures[localId.intValue()] = features.get((int)featureVectorId);
        });
        return (Double)this.mdl.predict(VectorUtils.of(newFeatures));
    }

    public Map<Integer, Integer> getFeaturesMapping() {
        return this.featuresMapping;
    }

    public IgniteModel<Vector, Double> getMdl() {
        return this.mdl;
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean pretty) {
        String mappingStr = this.featuresMapping.entrySet().stream().map(e -> String.format("%d -> %d", e.getKey(), e.getValue())).collect(Collectors.joining(", ", "{", "}"));
        return ModelTrace.builder("ModelOnFeatureSubspace", pretty).addField("features mapping", mappingStr).addField("model", this.mdl.toString(false)).toString();
    }
}

