/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.util;

import java.io.IOException;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.ml.math.exceptions.knn.FileParsingException;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.VectorUtils;
import org.apache.ignite.ml.util.MLSandboxDatasets;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class SandboxMLCache {
    private final Ignite ignite;
    private static final ResourcePatternResolver RESOURCE_RESOLVER = new PathMatchingResourcePatternResolver(SandboxMLCache.class.getClassLoader());

    public SandboxMLCache(Ignite ignite) {
        this.ignite = ignite;
    }

    public IgniteCache<Integer, double[]> fillCacheWith(double[][] data) {
        CacheConfiguration cacheConfiguration = new CacheConfiguration();
        cacheConfiguration.setName("TEST_" + UUID.randomUUID());
        cacheConfiguration.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 10));
        IgniteCache cache = this.ignite.createCache(cacheConfiguration);
        for (int i = 0; i < data.length; ++i) {
            cache.put((Object)i, (Object)data[i]);
        }
        return cache;
    }

    public List<String> loadDataset(MLSandboxDatasets dataset) throws IOException {
        ArrayList<String> res = new ArrayList<String>();
        Resource[] resources = RESOURCE_RESOLVER.getResources("classpath*:*/" + dataset.getFileName());
        A.ensure((resources.length == 1 ? 1 : 0) != 0, (String)"Cannot find resource");
        Scanner scanner = new Scanner(resources[0].getInputStream());
        if (dataset.hasHeader() && scanner.hasNextLine()) {
            scanner.nextLine();
        }
        while (scanner.hasNextLine()) {
            String row = scanner.nextLine();
            res.add(row);
        }
        return res;
    }

    public IgniteCache<Integer, Vector> fillCacheWith(MLSandboxDatasets dataset) throws IOException {
        IgniteCache<Integer, Vector> cache = this.getCache();
        String fileName = dataset.getFileName();
        Resource[] resources = RESOURCE_RESOLVER.getResources("classpath*:*/" + fileName);
        A.ensure((resources.length == 1 ? 1 : 0) != 0, (String)"Cannot find resource");
        Scanner scanner = new Scanner(resources[0].getInputStream());
        int cnt = 0;
        while (scanner.hasNextLine()) {
            String row = scanner.nextLine();
            if (dataset.hasHeader() && cnt == 0) {
                ++cnt;
                continue;
            }
            String[] cells = row.split(dataset.getSeparator());
            double[] data = new double[cells.length];
            NumberFormat format = NumberFormat.getInstance(Locale.FRANCE);
            for (int i = 0; i < cells.length; ++i) {
                try {
                    if (cells[i].equals("")) {
                        data[i] = Double.NaN;
                        continue;
                    }
                    data[i] = Double.valueOf(cells[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    try {
                        data[i] = format.parse(cells[i]).doubleValue();
                        continue;
                    }
                    catch (ParseException e1) {
                        throw new FileParsingException(cells[i], i, Paths.get(dataset.getFileName(), new String[0]));
                    }
                }
            }
            cache.put((Object)cnt++, (Object)VectorUtils.of(data));
        }
        return cache;
    }

    private IgniteCache<Integer, Vector> getCache() {
        CacheConfiguration cacheConfiguration = new CacheConfiguration();
        cacheConfiguration.setName("TUTORIAL_" + UUID.randomUUID());
        cacheConfiguration.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 10));
        return this.ignite.createCache(cacheConfiguration);
    }
}

