/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.paramgrid;

import org.apache.ignite.ml.selection.paramgrid.HyperParameterTuningStrategy;
import org.apache.ignite.ml.util.genetic.CrossoverStrategy;
import org.apache.ignite.ml.util.genetic.SelectionStrategy;

public class EvolutionOptimizationStrategy
extends HyperParameterTuningStrategy {
    private long seed = 1234L;
    private int amountOfEliteChromosomes = 2;
    private int amountOfGenerations = 10;
    private double crossingoverProbability = 0.9;
    private double mutationProbability = 0.1;
    private CrossoverStrategy crossoverStgy = CrossoverStrategy.UNIFORM;
    private SelectionStrategy selectionStgy = SelectionStrategy.ROULETTE_WHEEL;

    public long getSeed() {
        return this.seed;
    }

    public int getAmountOfGenerations() {
        return this.amountOfGenerations;
    }

    public int getAmountOfEliteChromosomes() {
        return this.amountOfEliteChromosomes;
    }

    public double getCrossingoverProbability() {
        return this.crossingoverProbability;
    }

    public double getMutationProbability() {
        return this.mutationProbability;
    }

    public CrossoverStrategy getCrossoverStgy() {
        return this.crossoverStgy;
    }

    public SelectionStrategy getSelectionStgy() {
        return this.selectionStgy;
    }

    public EvolutionOptimizationStrategy withSeed(long seed) {
        this.seed = seed;
        return this;
    }

    public EvolutionOptimizationStrategy withCrossingoverProbability(double crossingoverProbability) {
        this.crossingoverProbability = crossingoverProbability;
        return this;
    }

    public EvolutionOptimizationStrategy withMutationProbability(double mutationProbability) {
        this.mutationProbability = mutationProbability;
        return this;
    }

    public EvolutionOptimizationStrategy withCrossoverStgy(CrossoverStrategy crossoverStgy) {
        this.crossoverStgy = crossoverStgy;
        return this;
    }

    public EvolutionOptimizationStrategy withSelectionStgy(SelectionStrategy selectionStgy) {
        this.selectionStgy = selectionStgy;
        return this;
    }

    @Override
    public String getName() {
        return "Evolution Optimization";
    }
}

