/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.cv;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CrossValidationResult {
    private Map<String, Double> bestHyperParams;
    private double[] bestScore;
    private Map<Map<String, Double>, double[]> scoringBoard = new HashMap<Map<String, Double>, double[]>();

    public synchronized double getBest(String hyperParamName) {
        return this.bestHyperParams.get(hyperParamName);
    }

    public synchronized double[] getBestScore() {
        return this.bestScore;
    }

    synchronized void addScores(double[] locScores, Map<String, Double> paramMap) {
        this.scoringBoard.put(paramMap, locScores);
    }

    public synchronized double getBestAvgScore() {
        if (this.bestScore == null) {
            return Double.MIN_VALUE;
        }
        return Arrays.stream(this.bestScore).average().orElse(Double.MIN_VALUE);
    }

    synchronized void setBestScore(double[] bestScore) {
        this.bestScore = bestScore;
    }

    public synchronized void setBestHyperParams(Map<String, Double> bestHyperParams) {
        this.bestHyperParams = bestHyperParams;
    }

    public synchronized Map<Map<String, Double>, double[]> getScoringBoard() {
        return Collections.unmodifiableMap(this.scoringBoard);
    }

    public synchronized Map<String, Double> getBestHyperParams() {
        return Collections.unmodifiableMap(this.bestHyperParams);
    }

    public synchronized String toString() {
        return "CrossValidationResult{bestHyperParams=" + this.bestHyperParams + ", bestScore=" + Arrays.toString(this.bestScore) + '}';
    }
}

