/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.preprocessing.binarization;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.ml.environment.deploy.DeployableObject;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.structures.LabeledVector;

public final class BinarizationPreprocessor<K, V>
implements Preprocessor<K, V>,
DeployableObject {
    private static final long serialVersionUID = 6877811577892621239L;
    private final double threshold;
    private final Preprocessor<K, V> basePreprocessor;

    public BinarizationPreprocessor(double threshold, Preprocessor<K, V> basePreprocessor) {
        this.threshold = threshold;
        this.basePreprocessor = basePreprocessor;
    }

    @Override
    public LabeledVector apply(K k, V v) {
        LabeledVector res = (LabeledVector)this.basePreprocessor.apply(k, v);
        for (int i = 0; i < res.size(); ++i) {
            if (res.get(i) > this.threshold) {
                res.set(i, 1.0);
                continue;
            }
            res.set(i, 0.0);
        }
        return res;
    }

    public double getThreshold() {
        return this.threshold;
    }

    @Override
    public List<Object> getDependencies() {
        return Collections.singletonList(this.basePreprocessor);
    }
}

