/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.naivebayes.gaussian;

import java.io.Serializable;
import org.apache.ignite.ml.Exportable;
import org.apache.ignite.ml.Exporter;
import org.apache.ignite.ml.IgniteModel;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.naivebayes.gaussian.GaussianNaiveBayesSumsHolder;

public final class GaussianNaiveBayesModel
implements IgniteModel<Vector, Double>,
Exportable<GaussianNaiveBayesModel>,
Serializable {
    private static final long serialVersionUID = -127386523291350345L;
    private final double[][] means;
    private final double[][] variances;
    private final double[] classProbabilities;
    private final double[] labels;
    private final GaussianNaiveBayesSumsHolder sumsHolder;

    public GaussianNaiveBayesModel(double[][] means, double[][] variances, double[] classProbabilities, double[] labels, GaussianNaiveBayesSumsHolder sumsHolder) {
        this.means = means;
        this.variances = variances;
        this.classProbabilities = classProbabilities;
        this.labels = labels;
        this.sumsHolder = sumsHolder;
    }

    @Override
    public <P> void saveModel(Exporter<GaussianNaiveBayesModel, P> exporter, P path) {
        exporter.save(this, path);
    }

    @Override
    public Double predict(Vector vector) {
        int k = this.classProbabilities.length;
        double maxProbability = 0.0;
        int max = 0;
        for (int i = 0; i < k; ++i) {
            double p = this.classProbabilities[i];
            for (int j = 0; j < vector.size(); ++j) {
                double x = vector.get(j);
                double g = this.gauss(x, this.means[i][j], this.variances[i][j]);
                p *= g;
            }
            if (!(p > maxProbability)) continue;
            max = i;
            maxProbability = p;
        }
        return this.labels[max];
    }

    public double[][] getMeans() {
        return this.means;
    }

    public double[][] getVariances() {
        return this.variances;
    }

    public double[] getClassProbabilities() {
        return this.classProbabilities;
    }

    public GaussianNaiveBayesSumsHolder getSumsHolder() {
        return this.sumsHolder;
    }

    private double gauss(double x, double mean, double variance) {
        return Math.exp(-1.0 * Math.pow(x - mean, 2.0) / (2.0 * variance)) / Math.sqrt(Math.PI * 2 * variance);
    }
}

