/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.genetic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeLoadBalancer;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.ml.genetic.Chromosome;
import org.apache.ignite.ml.genetic.RouletteWheelSelectionJob;
import org.apache.ignite.ml.genetic.parameter.GAConfiguration;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoadBalancerResource;
import org.jetbrains.annotations.NotNull;

public class RouletteWheelSelectionTask
extends ComputeTaskAdapter<LinkedHashMap<Long, Double>, List<Long>> {
    @IgniteInstanceResource
    private Ignite ignite = null;
    @LoadBalancerResource
    ComputeLoadBalancer balancer;
    private GAConfiguration cfg = null;

    public RouletteWheelSelectionTask(GAConfiguration cfg) {
        this.cfg = cfg;
    }

    private Double calculateTotalFitness() {
        double totalFitnessScore = 0.0;
        IgniteCache cache = this.ignite.cache("populationCache");
        SqlFieldsQuery sql = new SqlFieldsQuery("select SUM(FITNESSSCORE) from Chromosome");
        try (FieldsQueryCursor cursor = cache.query(sql);){
            for (List row : cursor) {
                totalFitnessScore = (Double)row.get(0);
            }
        }
        return totalFitnessScore;
    }

    @NotNull
    public Map<ComputeJob, ClusterNode> map(List<ClusterNode> nodes, LinkedHashMap<Long, Double> chromosomeKeyFitness) throws IgniteException {
        HashMap<ComputeJob, ClusterNode> map = new HashMap<ComputeJob, ClusterNode>();
        Affinity affinity = this.ignite.affinity("populationCache");
        Double totalFitness = this.calculateTotalFitness();
        int populationSize = this.cfg.getPopulationSize();
        for (int i = 0; i < populationSize; ++i) {
            RouletteWheelSelectionJob job = new RouletteWheelSelectionJob(totalFitness, chromosomeKeyFitness);
            map.put((ComputeJob)job, this.balancer.getBalancedNode((ComputeJob)job, null));
        }
        return map;
    }

    public List<Long> reduce(List<ComputeJobResult> list) throws IgniteException {
        List<Chromosome> parents = list.stream().map(x -> (Chromosome)x.getData()).collect(Collectors.toList());
        return this.createParents(parents);
    }

    private List<Long> createParents(List<Chromosome> parents) {
        IgniteCache cache = this.ignite.cache("populationCache");
        cache.clear();
        ArrayList<Long> keys = new ArrayList<Long>();
        parents.stream().forEach(x -> {
            long[] genes = x.getGenes();
            Chromosome newparent = new Chromosome(genes);
            cache.put((Object)newparent.id(), (Object)newparent);
            keys.add(newparent.id());
        });
        return keys;
    }

    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
        IgniteException err = res.getException();
        if (err != null) {
            return ComputeJobResultPolicy.FAILOVER;
        }
        return ComputeJobResultPolicy.WAIT;
    }
}

