/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.genetic;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.ml.genetic.Chromosome;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;

public class RouletteWheelSelectionJob
extends ComputeJobAdapter {
    @IgniteInstanceResource
    private Ignite ignite = null;
    @LoggerResource
    private IgniteLogger log = null;
    Double totalFitnessScore = null;
    LinkedHashMap<Long, Double> map = null;

    public RouletteWheelSelectionJob(Double totalFitnessScore, LinkedHashMap<Long, Double> map) {
        this.totalFitnessScore = totalFitnessScore;
        this.map = map;
    }

    public Chromosome execute() throws IgniteException {
        IgniteCache populationCache = this.ignite.cache("populationCache");
        int value = this.spintheWheel(this.totalFitnessScore);
        double partialSum = 0.0;
        boolean notFound = true;
        Map sortedAscendingMap = this.map.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        Iterator entries = sortedAscendingMap.entrySet().iterator();
        Long chromosomeKey = -1L;
        while (entries.hasNext() && notFound) {
            Map.Entry entry = entries.next();
            Long key = (Long)entry.getKey();
            Double fitnessScore = (Double)entry.getValue();
            if (!((partialSum += fitnessScore.doubleValue()) >= (double)value)) continue;
            notFound = false;
            chromosomeKey = key;
        }
        return (Chromosome)populationCache.get((Object)chromosomeKey);
    }

    private int spintheWheel(Double fitnessScore) {
        Random randomGenerator = new Random();
        return randomGenerator.nextInt(fitnessScore.intValue());
    }
}

