/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.environment.parallelism;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.ml.environment.parallelism.Promise;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.functions.IgniteSupplier;

public interface ParallelismStrategy {
    public static final IgniteFunction<Integer, Type> ON_DEFAULT_POOL = part -> Type.ON_DEFAULT_POOL;
    public static final IgniteFunction<Integer, Type> NO_PARALLELISM = part -> Type.NO_PARALLELISM;

    public <T> Promise<T> submit(IgniteSupplier<T> var1);

    public int getParallelism();

    default public <T> List<Promise<T>> submit(List<IgniteSupplier<T>> tasks) {
        ArrayList<Promise<T>> results = new ArrayList<Promise<T>>();
        for (IgniteSupplier<T> task : tasks) {
            results.add(this.submit(task));
        }
        return results;
    }

    public static enum Type {
        NO_PARALLELISM,
        ON_DEFAULT_POOL;

    }
}

