/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.environment.logging;

import org.apache.ignite.ml.IgniteModel;
import org.apache.ignite.ml.environment.logging.MLLogger;
import org.apache.ignite.ml.math.Tracer;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;

public class ConsoleLogger
implements MLLogger {
    private final MLLogger.VerboseLevel maxVerboseLevel;
    private final String clsName;

    private ConsoleLogger(MLLogger.VerboseLevel maxVerboseLevel, String clsName) {
        this.clsName = clsName;
        this.maxVerboseLevel = maxVerboseLevel;
    }

    public static Factory factory(MLLogger.VerboseLevel maxVerboseLevel) {
        return new Factory(maxVerboseLevel);
    }

    @Override
    public Vector log(Vector vector) {
        Tracer.showAscii(vector);
        return vector;
    }

    @Override
    public <K, V> IgniteModel<K, V> log(MLLogger.VerboseLevel verboseLevel, IgniteModel<K, V> mdl) {
        this.print(verboseLevel, mdl.toString(true));
        return mdl;
    }

    @Override
    public void log(MLLogger.VerboseLevel verboseLevel, String fmtStr, Object ... params) {
        this.print(verboseLevel, String.format(fmtStr, params));
    }

    private void print(MLLogger.VerboseLevel verboseLevel, String line) {
        if (this.maxVerboseLevel.compareTo(verboseLevel) >= 0) {
            System.out.println(String.format("%s [%s] %s", this.clsName, verboseLevel.name(), line));
        }
    }

    public static class Factory
    implements MLLogger.Factory {
        private static final long serialVersionUID = 5864605548782107893L;
        private final MLLogger.VerboseLevel maxVerboseLevel;
        public static final IgniteFunction<Integer, MLLogger.Factory> LOW = part -> new Factory(MLLogger.VerboseLevel.LOW);
        public static final IgniteFunction<Integer, MLLogger.Factory> HIGH = part -> new Factory(MLLogger.VerboseLevel.HIGH);
        public static final IgniteFunction<Integer, MLLogger.Factory> OFF = part -> new Factory(MLLogger.VerboseLevel.OFF);

        private Factory(MLLogger.VerboseLevel maxVerboseLevel) {
            this.maxVerboseLevel = maxVerboseLevel;
        }

        @Override
        public <T> MLLogger create(Class<T> targetCls) {
            return new ConsoleLogger(this.maxVerboseLevel, targetCls.getName());
        }
    }
}

