/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.environment.deploy;

import java.util.List;
import org.apache.ignite.ml.environment.deploy.DeployableObject;
import org.apache.ignite.ml.environment.deploy.DeployingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployingContextImpl
implements DeployingContext {
    private static final Logger logger = LoggerFactory.getLogger(DeployingContextImpl.class);
    private transient Class<?> preprocessorClass;
    private transient ClassLoader clientClassLoader;

    @Override
    public Class<?> userClass() {
        return this.preprocessorClass == null ? this.getClass() : this.preprocessorClass;
    }

    @Override
    public ClassLoader clientClassLoader() {
        return this.clientClassLoader == null ? this.getClass().getClassLoader() : this.clientClassLoader;
    }

    @Override
    public void initByClientObject(Object jobObj) {
        List<Object> deps;
        if (jobObj == null) {
            logger.warn("Attempt to initialize deploy context by null");
            return;
        }
        if (this.preprocessorClass != null) {
            logger.warn("Reinitialize deploying context [class=" + jobObj.getClass().getName() + "]");
        }
        Object objectToDeploy = jobObj;
        while (objectToDeploy instanceof DeployableObject && !(deps = ((DeployableObject)objectToDeploy).getDependencies()).isEmpty()) {
            objectToDeploy = deps.get(0);
        }
        assert (objectToDeploy != null);
        this.preprocessorClass = objectToDeploy.getClass();
        this.clientClassLoader = this.preprocessorClass.getClassLoader();
    }

    @Override
    public void init(DeployingContext other) {
        this.clientClassLoader = other.clientClassLoader();
        this.preprocessorClass = other.userClass();
    }
}

