/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.xgboost.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.ignite.ml.inference.parser.ModelParser;
import org.apache.ignite.ml.math.primitives.vector.NamedVector;
import org.apache.ignite.ml.xgboost.XGModelComposition;
import org.apache.ignite.ml.xgboost.parser.XGBoostModelLexer;
import org.apache.ignite.ml.xgboost.parser.XGBoostModelParser;
import org.apache.ignite.ml.xgboost.parser.visitor.XGModelVisitor;

public class XGModelParser
implements ModelParser<NamedVector, Double, XGModelComposition> {
    private static final long serialVersionUID = -5819843559270294718L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XGModelComposition parse(byte[] mdl) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(mdl);){
            CharStream cStream = CharStreams.fromStream((InputStream)bais);
            XGBoostModelLexer lexer = new XGBoostModelLexer(cStream);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            XGBoostModelParser parser = new XGBoostModelParser((TokenStream)tokens);
            XGModelVisitor visitor = new XGModelVisitor();
            XGModelComposition xGModelComposition = (XGModelComposition)visitor.visit((ParseTree)parser.xgModel());
            return xGModelComposition;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

