/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.inference.parser;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.ignite.ml.inference.parser.TensorFlowBaseModelParser;
import org.apache.ignite.ml.inference.util.DirectorySerializer;
import org.tensorflow.SavedModelBundle;
import org.tensorflow.Session;

public class TensorFlowSavedModelModelParser<I, O>
extends TensorFlowBaseModelParser<I, O> {
    private static final long serialVersionUID = 5638083440240281879L;
    private static final String TMP_DIR_PREFIX = "tensorflow_saved_model_";
    private final String[] tags;

    public TensorFlowSavedModelModelParser(String ... tags) {
        this.tags = tags;
    }

    @Override
    public Session parseModel(byte[] mdl) {
        Path dir = null;
        try {
            dir = Files.createTempDirectory(TMP_DIR_PREFIX, new FileAttribute[0]);
            DirectorySerializer.deserialize((Path)dir.toAbsolutePath(), (byte[])mdl);
            SavedModelBundle bundle = SavedModelBundle.load((String)dir.toString(), (String[])this.tags);
            Session session = bundle.session();
            return session;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (dir != null) {
                DirectorySerializer.deleteDirectory((Path)dir);
            }
        }
    }
}

