/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics.exporters;

import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metrics.MetricProvider;
import org.apache.ignite.internal.metrics.exporters.BasicMetricExporter;
import org.apache.ignite.internal.metrics.exporters.configuration.ExporterView;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public abstract class PushMetricExporter
extends BasicMetricExporter {
    protected final IgniteLogger log = Loggers.forClass(this.getClass());
    @Nullable
    private volatile ScheduledFuture<?> fut;
    private volatile ScheduledExecutorService scheduler;
    private long period;

    @Override
    public void start(MetricProvider metricProvider, ExporterView conf, Supplier<UUID> clusterIdSupplier, String nodeName) {
        super.start(metricProvider, conf, clusterIdSupplier, nodeName);
        this.scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)IgniteThreadFactory.create((String)nodeName, (String)("metrics-exporter-" + this.name()), (IgniteLogger)this.log, (ThreadOperation[])new ThreadOperation[0]));
        this.reconfigure(conf);
    }

    @Override
    public void reconfigure(ExporterView newVal) {
        long newPeriod = this.period(newVal);
        ScheduledFuture<?> localFuture = this.fut;
        if (localFuture == null || this.period != newPeriod) {
            if (localFuture != null) {
                localFuture.cancel(false);
            }
            this.period = newPeriod;
            this.fut = this.scheduler.scheduleWithFixedDelay(() -> {
                try {
                    this.report();
                }
                catch (Throwable th) {
                    this.log.error("Metrics export error. This exporter will be stopped [class=" + this.getClass() + ",name=" + this.name() + "]", th);
                    throw th;
                }
            }, newPeriod, newPeriod, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void stop() {
        ScheduledExecutorService localScheduler;
        ScheduledFuture<?> localFuture = this.fut;
        if (localFuture != null) {
            localFuture.cancel(false);
            this.fut = null;
        }
        if ((localScheduler = this.scheduler) != null) {
            IgniteUtils.shutdownAndAwaitTermination((ExecutorService)localScheduler, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    protected abstract long period(ExporterView var1);

    public abstract void report();
}

