/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.server.time;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.configuration.SystemDistributedConfiguration;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.failure.FailureType;
import org.apache.ignite.internal.failure.handlers.FailureHandler;
import org.apache.ignite.internal.failure.handlers.NoOpFailureHandler;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.IgniteThrottledLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.metrics.MetaStorageMetrics;
import org.apache.ignite.internal.metastorage.server.time.ClusterTime;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.PendingComparableValuesTracker;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ClusterTimeImpl
implements ClusterTime,
MetaStorageMetrics,
ManuallyCloseable {
    private static final IgniteLogger LOG = Loggers.forClass(ClusterTimeImpl.class);
    private final String nodeName;
    private final IgniteSpinBusyLock busyLock;
    private final HybridClock clock;
    private final FailureProcessor failureProcessor;
    private final PendingComparableValuesTracker<HybridTimestamp, Void> safeTime = new PendingComparableValuesTracker((Comparable)HybridTimestamp.MIN_VALUE);
    @Nullable
    private SafeTimeScheduler safeTimeScheduler;
    private long lastSchedulerStoppedTerm = -1L;

    @Override
    public long safeTimeLag() {
        return this.clock.now().getPhysical() - ((HybridTimestamp)this.safeTime.current()).getPhysical();
    }

    @TestOnly
    public ClusterTimeImpl(String nodeName, IgniteSpinBusyLock busyLock, HybridClock clock) {
        this(nodeName, busyLock, clock, (FailureProcessor)new FailureManager((FailureHandler)new NoOpFailureHandler()));
    }

    public ClusterTimeImpl(String nodeName, IgniteSpinBusyLock busyLock, HybridClock clock, FailureProcessor failureProcessor) {
        this.nodeName = nodeName;
        this.busyLock = busyLock;
        this.clock = clock;
        this.failureProcessor = failureProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSafeTimeScheduler(SyncTimeAction syncTimeAction, SystemDistributedConfiguration configuration, long term) {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            ClusterTimeImpl clusterTimeImpl = this;
            synchronized (clusterTimeImpl) {
                block10: {
                    if (this.lastSchedulerStoppedTerm <= term) break block10;
                    return;
                }
                assert (this.safeTimeScheduler == null);
                this.safeTimeScheduler = new SafeTimeScheduler(syncTimeAction, configuration);
                this.safeTimeScheduler.start();
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public synchronized void stopSafeTimeScheduler(long term) {
        this.lastSchedulerStoppedTerm = term;
        if (this.safeTimeScheduler != null) {
            this.safeTimeScheduler.stop();
            this.safeTimeScheduler = null;
        }
    }

    public void close() throws Exception {
        this.stopSafeTimeScheduler(Long.MAX_VALUE);
        this.safeTime.close((Exception)((Object)new NodeStoppingException()));
    }

    public HybridTimestamp currentSafeTime() {
        return (HybridTimestamp)this.safeTime.current();
    }

    public CompletableFuture<Void> waitFor(HybridTimestamp time) {
        return this.safeTime.waitFor((Comparable)time);
    }

    public void updateSafeTime(HybridTimestamp newValue) {
        this.safeTime.update((Comparable)newValue, null);
    }

    public synchronized void adjustClock(HybridTimestamp ts) {
        this.clock.update(ts);
        if (this.safeTimeScheduler != null) {
            this.safeTimeScheduler.schedule();
        }
    }

    private class SafeTimeScheduler {
        private final SyncTimeAction syncTimeAction;
        private final SystemDistributedConfiguration configuration;
        private final ScheduledExecutorService executorService;
        private final IgniteThrottledLogger throttledLogger;
        @Nullable
        private ScheduledFuture<?> currentTask;

        SafeTimeScheduler(SyncTimeAction syncTimeAction, SystemDistributedConfiguration configuration) {
            this.executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)IgniteThreadFactory.create((String)ClusterTimeImpl.this.nodeName, (String)"meta-storage-safe-time", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[0]));
            this.throttledLogger = Loggers.toThrottledLogger((IgniteLogger)LOG, (Executor)this.executorService);
            this.syncTimeAction = syncTimeAction;
            this.configuration = configuration;
        }

        void start() {
            this.schedule();
            LOG.info("Started safe time scheduler", new Object[0]);
        }

        synchronized void schedule() {
            if (this.currentTask != null) {
                this.currentTask.cancel(false);
            }
            this.currentTask = this.executorService.schedule(() -> {
                block3: {
                    try {
                        this.tryToSyncTimeAndReschedule();
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                    }
                    catch (Throwable t) {
                        ClusterTimeImpl.this.failureProcessor.process(new FailureContext(FailureType.CRITICAL_ERROR, t));
                        if (!(t instanceof Error)) break block3;
                        throw t;
                    }
                }
            }, (long)((Long)this.configuration.idleSafeTimeSyncIntervalMillis().value()), TimeUnit.MILLISECONDS);
        }

        private void tryToSyncTimeAndReschedule() {
            if (!ClusterTimeImpl.this.busyLock.enterBusy()) {
                return;
            }
            try {
                this.syncTimeAction.syncTime(ClusterTimeImpl.this.clock.now()).whenComplete((v, e) -> {
                    if (e != null) {
                        if (ExceptionUtils.hasCause((Throwable)e, (Class[])new Class[]{TimeoutException.class})) {
                            this.throttledLogger.warn("Unable to perform idle time sync because of timeout on meta storage service.", new Object[0]);
                        } else if (!ExceptionUtils.hasCause((Throwable)e, (Class[])new Class[]{NodeStoppingException.class})) {
                            ClusterTimeImpl.this.failureProcessor.process(new FailureContext(e, "Unable to perform idle time sync"));
                        }
                    }
                });
                this.schedule();
            }
            finally {
                ClusterTimeImpl.this.busyLock.leaveBusy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            LOG.info("Stopping safe time scheduler", new Object[0]);
            SafeTimeScheduler safeTimeScheduler = this;
            synchronized (safeTimeScheduler) {
                if (this.currentTask != null) {
                    this.currentTask.cancel(false);
                }
            }
            IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.executorService, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    @FunctionalInterface
    public static interface SyncTimeAction {
        public CompletableFuture<Void> syncTime(HybridTimestamp var1);
    }
}

