/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.server.persistence;

import java.nio.file.Path;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.metastorage.server.ReadOperationForCompactionTracker;
import org.apache.ignite.internal.metastorage.server.persistence.RocksDbKeyValueStorage;
import org.apache.ignite.internal.rocksdb.EncryptionPluginUtils;
import org.gridgain.internal.encryption.EncryptionManager;
import org.rocksdb.DBOptions;
import org.rocksdb.Env;
import org.rocksdb.GgEncryptionEnv;

public class EncryptedRocksDbKeyValueStorage
extends RocksDbKeyValueStorage {
    private final Supplier<EncryptionManager> encryptionManager;

    public EncryptedRocksDbKeyValueStorage(String nodeName, Path dbPath, FailureManager failureManager, ReadOperationForCompactionTracker readOperationForCompactionTracker, ScheduledExecutorService scheduledExecutor, Supplier<EncryptionManager> encryptionManagerSupplier) {
        super(nodeName, dbPath, (FailureProcessor)failureManager, readOperationForCompactionTracker, scheduledExecutor);
        this.encryptionManager = encryptionManagerSupplier;
    }

    @Override
    protected DBOptions createDbOptions() {
        DBOptions dbOptions = super.createDbOptions();
        EncryptionManager em = this.encryptionManager.get();
        GgEncryptionEnv env = EncryptionPluginUtils.createDbOptionsEnvironment((EncryptionManager)em, res -> this.rocksResources.add(this.rocksResources.size() - 2, res));
        if (env != null) {
            dbOptions.setEnv((Env)env);
        }
        return dbOptions;
    }
}

