/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.command;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.metastorage.command.RemoveCommand;
import org.apache.ignite.internal.metastorage.command.RemoveCommandBuilder;
import org.apache.ignite.internal.metastorage.command.RemoveCommandSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class RemoveCommandImpl
implements RemoveCommand,
Cloneable {
    public static final short GROUP_TYPE = 111;
    public static final short TYPE = 41;
    @IgniteToStringInclude
    private final HybridTimestamp initiatorTime;
    @IgniteToStringInclude
    private final ByteBuffer key;
    @IgniteToStringInclude
    private HybridTimestamp safeTime;

    private RemoveCommandImpl(HybridTimestamp initiatorTime, ByteBuffer key, HybridTimestamp safeTime) {
        this.initiatorTime = initiatorTime;
        this.key = key;
        this.safeTime = safeTime;
    }

    @Override
    public HybridTimestamp initiatorTime() {
        return this.initiatorTime;
    }

    @Override
    public ByteBuffer key() {
        return this.key;
    }

    @Override
    public void safeTime(HybridTimestamp safeTime) {
        this.safeTime = safeTime;
    }

    @Override
    public HybridTimestamp safeTime() {
        return this.safeTime;
    }

    public MessageSerializer serializer() {
        return RemoveCommandSerializer.INSTANCE;
    }

    public short groupType() {
        return 111;
    }

    public String toString() {
        return S.toString(RemoveCommandImpl.class, (Object)this);
    }

    public short messageType() {
        return 41;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RemoveCommandImpl otherMessage = (RemoveCommandImpl)other;
        return Objects.equals(this.initiatorTime, otherMessage.initiatorTime) && Objects.equals(this.key, otherMessage.key) && Objects.equals(this.safeTime, otherMessage.safeTime);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.initiatorTime, this.key, this.safeTime);
        return result;
    }

    public RemoveCommandImpl clone() {
        try {
            return (RemoveCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static RemoveCommandBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements RemoveCommandBuilder {
        private HybridTimestamp initiatorTime;
        private ByteBuffer key;
        private HybridTimestamp safeTime;

        private Builder() {
        }

        @Override
        public RemoveCommandBuilder initiatorTime(HybridTimestamp initiatorTime) {
            Objects.requireNonNull(initiatorTime, "initiatorTime is not marked @Nullable");
            this.initiatorTime = initiatorTime;
            return this;
        }

        @Override
        public RemoveCommandBuilder key(ByteBuffer key) {
            Objects.requireNonNull(key, "key is not marked @Nullable");
            this.key = key;
            return this;
        }

        @Override
        public RemoveCommandBuilder safeTime(HybridTimestamp safeTime) {
            this.safeTime = safeTime;
            return this;
        }

        @Override
        public HybridTimestamp initiatorTime() {
            return this.initiatorTime;
        }

        @Override
        public ByteBuffer key() {
            return this.key;
        }

        @Override
        public HybridTimestamp safeTime() {
            return this.safeTime;
        }

        @Override
        public RemoveCommand build() {
            return new RemoveCommandImpl(Objects.requireNonNull(this.initiatorTime, "initiatorTime is not marked @Nullable"), Objects.requireNonNull(this.key, "key is not marked @Nullable"), this.safeTime);
        }

        @Override
        public RemoveCommand buildDeserialized() {
            return new RemoveCommandImpl(this.initiatorTime, this.key, this.safeTime);
        }
    }
}

