/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.command;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.metastorage.command.MetaStorageCommandsFactory;
import org.apache.ignite.internal.metastorage.command.MetaStorageCommandsTypeInfos;
import org.apache.ignite.internal.metastorage.command.RemoveAllCommand;
import org.apache.ignite.internal.metastorage.command.RemoveAllCommandBuilder;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class RemoveAllCommandDeserializer
implements MessageDeserializer<RemoveAllCommand> {
    private final RemoveAllCommandBuilder msg;

    RemoveAllCommandDeserializer(MetaStorageCommandsFactory messageFactory) {
        this.msg = messageFactory.removeAllCommand();
    }

    public Class<RemoveAllCommand> klass() {
        return RemoveAllCommand.class;
    }

    public RemoveAllCommand getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(MetaStorageCommandsTypeInfos.removeAllCommand());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readHybridTimestamp("initiatorTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.initiatorTime((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readList("keys", MessageCollectionItemType.BYTE_BUFFER);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.keys((List<ByteBuffer>)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readHybridTimestamp("safeTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.safeTime((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RemoveAllCommand.class);
    }
}

