/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.command;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.metastorage.CommandId;
import org.apache.ignite.internal.metastorage.command.InvokeCommand;
import org.apache.ignite.internal.metastorage.command.InvokeCommandBuilder;
import org.apache.ignite.internal.metastorage.command.InvokeCommandSerializer;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class InvokeCommandImpl
implements InvokeCommand,
Cloneable {
    public static final short GROUP_TYPE = 111;
    public static final short TYPE = 10;
    @IgniteToStringInclude
    private final Condition condition;
    @IgniteToStringInclude
    private final List<Operation> failure;
    @IgniteToStringInclude
    private final CommandId id;
    @IgniteToStringInclude
    private final HybridTimestamp initiatorTime;
    @IgniteToStringInclude
    private HybridTimestamp safeTime;
    @IgniteToStringInclude
    private final List<Operation> success;

    private InvokeCommandImpl(Condition condition, List<Operation> failure, CommandId id, HybridTimestamp initiatorTime, HybridTimestamp safeTime, List<Operation> success) {
        this.condition = condition;
        this.failure = failure;
        this.id = id;
        this.initiatorTime = initiatorTime;
        this.safeTime = safeTime;
        this.success = success;
    }

    @Override
    public Condition condition() {
        return this.condition;
    }

    @Override
    public List<Operation> failure() {
        return this.failure;
    }

    @Override
    public CommandId id() {
        return this.id;
    }

    @Override
    public HybridTimestamp initiatorTime() {
        return this.initiatorTime;
    }

    @Override
    public void safeTime(HybridTimestamp safeTime) {
        this.safeTime = safeTime;
    }

    @Override
    public HybridTimestamp safeTime() {
        return this.safeTime;
    }

    @Override
    public List<Operation> success() {
        return this.success;
    }

    public MessageSerializer serializer() {
        return InvokeCommandSerializer.INSTANCE;
    }

    public short groupType() {
        return 111;
    }

    public String toString() {
        return S.toString(InvokeCommandImpl.class, (Object)this);
    }

    public short messageType() {
        return 10;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        InvokeCommandImpl otherMessage = (InvokeCommandImpl)other;
        return Objects.equals(this.condition, otherMessage.condition) && Objects.equals(this.failure, otherMessage.failure) && Objects.equals(this.id, otherMessage.id) && Objects.equals(this.initiatorTime, otherMessage.initiatorTime) && Objects.equals(this.safeTime, otherMessage.safeTime) && Objects.equals(this.success, otherMessage.success);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.condition, this.failure, this.id, this.initiatorTime, this.safeTime, this.success);
        return result;
    }

    public InvokeCommandImpl clone() {
        try {
            return (InvokeCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static InvokeCommandBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.condition != null) {
            this.condition.prepareMarshal(usedDescriptors, (Object)marshaller);
        }
        if (this.failure != null) {
            for (Operation obj : this.failure) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, (Object)marshaller);
            }
        }
        if (this.id != null) {
            this.id.prepareMarshal(usedDescriptors, (Object)marshaller);
        }
        if (this.success != null) {
            for (Operation obj : this.success) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, (Object)marshaller);
            }
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.condition != null) {
            this.condition.unmarshal((Object)marshaller, descriptorsObj);
        }
        if (this.failure != null) {
            for (Operation obj : this.failure) {
                if (obj == null) continue;
                obj.unmarshal((Object)marshaller, descriptorsObj);
            }
        }
        if (this.id != null) {
            this.id.unmarshal((Object)marshaller, descriptorsObj);
        }
        if (this.success != null) {
            for (Operation obj : this.success) {
                if (obj == null) continue;
                obj.unmarshal((Object)marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements InvokeCommandBuilder {
        private Condition condition;
        private List<Operation> failure;
        private CommandId id;
        private HybridTimestamp initiatorTime;
        private HybridTimestamp safeTime;
        private List<Operation> success;

        private Builder() {
        }

        @Override
        public InvokeCommandBuilder condition(Condition condition) {
            Objects.requireNonNull(condition, "condition is not marked @Nullable");
            this.condition = condition;
            return this;
        }

        @Override
        public InvokeCommandBuilder failure(List<Operation> failure) {
            Objects.requireNonNull(failure, "failure is not marked @Nullable");
            this.failure = failure;
            return this;
        }

        @Override
        public InvokeCommandBuilder id(CommandId id) {
            Objects.requireNonNull(id, "id is not marked @Nullable");
            this.id = id;
            return this;
        }

        @Override
        public InvokeCommandBuilder initiatorTime(HybridTimestamp initiatorTime) {
            Objects.requireNonNull(initiatorTime, "initiatorTime is not marked @Nullable");
            this.initiatorTime = initiatorTime;
            return this;
        }

        @Override
        public InvokeCommandBuilder safeTime(HybridTimestamp safeTime) {
            this.safeTime = safeTime;
            return this;
        }

        @Override
        public InvokeCommandBuilder success(List<Operation> success) {
            Objects.requireNonNull(success, "success is not marked @Nullable");
            this.success = success;
            return this;
        }

        @Override
        public Condition condition() {
            return this.condition;
        }

        @Override
        public List<Operation> failure() {
            return this.failure;
        }

        @Override
        public CommandId id() {
            return this.id;
        }

        @Override
        public HybridTimestamp initiatorTime() {
            return this.initiatorTime;
        }

        @Override
        public HybridTimestamp safeTime() {
            return this.safeTime;
        }

        @Override
        public List<Operation> success() {
            return this.success;
        }

        @Override
        public InvokeCommand build() {
            return new InvokeCommandImpl(Objects.requireNonNull(this.condition, "condition is not marked @Nullable"), Objects.requireNonNull(this.failure, "failure is not marked @Nullable"), Objects.requireNonNull(this.id, "id is not marked @Nullable"), Objects.requireNonNull(this.initiatorTime, "initiatorTime is not marked @Nullable"), this.safeTime, Objects.requireNonNull(this.success, "success is not marked @Nullable"));
        }

        @Override
        public InvokeCommand buildDeserialized() {
            return new InvokeCommandImpl(this.condition, this.failure, this.id, this.initiatorTime, this.safeTime, this.success);
        }
    }
}

