/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.command;

import org.apache.ignite.internal.metastorage.command.CompactionCommand;
import org.apache.ignite.internal.metastorage.command.CompactionCommandImpl;
import org.apache.ignite.internal.metastorage.command.MetaStorageCommandsTypeInfos;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;

class CompactionCommandSerializer
implements MessageSerializer<CompactionCommand> {
    public static final CompactionCommandSerializer INSTANCE = new CompactionCommandSerializer();

    private CompactionCommandSerializer() {
    }

    public boolean writeMessage(CompactionCommand msg, MessageWriter writer) throws MessageMappingException {
        CompactionCommandImpl message = (CompactionCommandImpl)msg;
        writer.setMessageTypeInfo(MetaStorageCommandsTypeInfos.compactionCommand());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)3)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeLong("compactionRevision", message.compactionRevision());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeHybridTimestamp("initiatorTime", message.initiatorTime());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeHybridTimestamp("safeTime", message.safeTime());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

