/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.server;

import java.util.List;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.server.NotifyWatchProcessorEvent;
import org.apache.ignite.internal.metastorage.server.WatchProcessor;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class UpdateEntriesEvent
implements NotifyWatchProcessorEvent {
    private static final IgniteLogger LOG = Loggers.forClass(UpdateEntriesEvent.class);
    @IgniteToStringInclude
    private final List<Entry> updatedEntries;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;

    public UpdateEntriesEvent(List<Entry> updatedEntries, HybridTimestamp timestamp) {
        assert (!updatedEntries.isEmpty());
        this.updatedEntries = updatedEntries;
        this.timestamp = timestamp;
    }

    @Override
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    @Override
    public void notify(WatchProcessor watchProcessor) {
        watchProcessor.notifyWatches(this.updatedEntries.get(0).revision(), this.updatedEntries, this.timestamp).whenComplete((res, err) -> {
            if (err != null) {
                LOG.error("Notify watches failed.", err);
            }
        });
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

