/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.server;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.ignite.internal.metastorage.exceptions.CompactedException;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.CompletableFutures;

public class ReadOperationForCompactionTracker {
    private final Map<ReadOperationKey, CompletableFuture<Void>> readOperationFutureByKey = new ConcurrentHashMap<ReadOperationKey, CompletableFuture<Void>>();
    private final AtomicLong longOperationIdGenerator = new AtomicLong();

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public TrackingToken track(long operationRevision, LongSupplier latestRevision, LongSupplier compactedRevision) throws CompactedException {
        long operationId = this.longOperationIdGenerator.getAndIncrement();
        while (true) {
            long currentOperationRevision;
            long l = currentOperationRevision = operationRevision == -1L ? latestRevision.getAsLong() : operationRevision;
            if (currentOperationRevision <= compactedRevision.getAsLong()) {
                if (operationRevision != -1L) throw new CompactedException(currentOperationRevision, compactedRevision.getAsLong());
                continue;
            }
            ReadOperationKey key = new ReadOperationKey(operationId, currentOperationRevision);
            TrackingToken trackingToken = () -> {
                CompletableFuture<Void> removed = this.readOperationFutureByKey.remove(key);
                if (removed != null) {
                    removed.complete(null);
                }
            };
            CompletableFuture operationFuture = new CompletableFuture();
            this.readOperationFutureByKey.put(key, operationFuture);
            if (currentOperationRevision > compactedRevision.getAsLong()) return trackingToken;
            trackingToken.close();
            if (operationRevision != -1L) throw new CompactedException(currentOperationRevision, compactedRevision.getAsLong());
        }
    }

    public CompletableFuture<Void> collect(long compactionRevision) {
        return this.readOperationFutureByKey.entrySet().stream().filter(entry -> ((ReadOperationKey)entry.getKey()).operationRevision <= compactionRevision).map(Map.Entry::getValue).collect(Collectors.collectingAndThen(Collectors.toList(), CompletableFutures::allOf));
    }

    private static class ReadOperationKey {
        @IgniteToStringInclude
        private final long readOperationId;
        private final long operationRevision;

        private ReadOperationKey(long readOperationId, long operationRevision) {
            assert (operationRevision >= 0L) : operationRevision;
            this.readOperationId = readOperationId;
            this.operationRevision = operationRevision;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReadOperationKey that = (ReadOperationKey)o;
            return this.operationRevision == that.operationRevision && this.readOperationId == that.readOperationId;
        }

        public int hashCode() {
            int result = Long.hashCode(this.readOperationId);
            result = 31 * result + Long.hashCode(this.operationRevision);
            return result;
        }

        public String toString() {
            return S.toString((Object)this);
        }
    }

    @FunctionalInterface
    public static interface TrackingToken
    extends AutoCloseable {
        @Override
        public void close();
    }
}

