/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.server.raft;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.Revisions;
import org.apache.ignite.internal.metastorage.command.GetAllCommand;
import org.apache.ignite.internal.metastorage.command.GetChecksumCommand;
import org.apache.ignite.internal.metastorage.command.GetCommand;
import org.apache.ignite.internal.metastorage.command.GetCurrentRevisionsCommand;
import org.apache.ignite.internal.metastorage.command.GetPrefixCommand;
import org.apache.ignite.internal.metastorage.command.GetRangeCommand;
import org.apache.ignite.internal.metastorage.command.PaginationCommand;
import org.apache.ignite.internal.metastorage.command.response.BatchResponse;
import org.apache.ignite.internal.metastorage.command.response.ChecksumInfo;
import org.apache.ignite.internal.metastorage.command.response.RevisionsInfo;
import org.apache.ignite.internal.metastorage.server.ChecksumAndRevisions;
import org.apache.ignite.internal.metastorage.server.KeyValueStorage;
import org.apache.ignite.internal.metastorage.server.raft.MetaStorageWriteHandler;
import org.apache.ignite.internal.metastorage.server.time.ClusterTimeImpl;
import org.apache.ignite.internal.raft.Command;
import org.apache.ignite.internal.raft.RaftGroupConfiguration;
import org.apache.ignite.internal.raft.RaftGroupConfigurationConverter;
import org.apache.ignite.internal.raft.ReadCommand;
import org.apache.ignite.internal.raft.WriteCommand;
import org.apache.ignite.internal.raft.service.BeforeApplyHandler;
import org.apache.ignite.internal.raft.service.CommandClosure;
import org.apache.ignite.internal.raft.service.RaftGroupListener;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class MetaStorageListener
implements RaftGroupListener,
BeforeApplyHandler {
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final MetaStorageWriteHandler writeHandler;
    private final KeyValueStorage storage;
    private final Consumer<RaftGroupConfiguration> onConfigurationCommitted;
    private final RaftGroupConfigurationConverter configurationConverter = new RaftGroupConfigurationConverter();

    @TestOnly
    public MetaStorageListener(KeyValueStorage storage, HybridClock clock, ClusterTimeImpl clusterTime) {
        this(storage, clock, clusterTime, newConfig -> {}, a -> {});
    }

    public MetaStorageListener(KeyValueStorage storage, HybridClock clock, ClusterTimeImpl clusterTime, Consumer<RaftGroupConfiguration> onConfigurationCommitted, IntConsumer idempotentCacheSizeListener) {
        this.storage = storage;
        this.onConfigurationCommitted = onConfigurationCommitted;
        this.writeHandler = new MetaStorageWriteHandler(storage, clock, clusterTime, idempotentCacheSizeListener);
    }

    public void onRead(Iterator<CommandClosure<ReadCommand>> iter) {
        if (!this.busyLock.enterBusy()) {
            iter.forEachRemaining(clo -> clo.result((Serializable)new RaftGroupListener.ShutdownException()));
        }
        try {
            this.onReadBusy(iter);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private void onReadBusy(Iterator<CommandClosure<ReadCommand>> iter) {
        while (iter.hasNext()) {
            CommandClosure<ReadCommand> clo = iter.next();
            ReadCommand command = (ReadCommand)clo.command();
            try {
                byte[] previousKey;
                if (command instanceof GetCommand) {
                    GetCommand getCmd = (GetCommand)command;
                    Entry e = getCmd.revision() == -1L ? this.storage.get(ByteUtils.toByteArray((ByteBuffer)getCmd.key())) : this.storage.get(ByteUtils.toByteArray((ByteBuffer)getCmd.key()), getCmd.revision());
                    clo.result((Serializable)e);
                    continue;
                }
                if (command instanceof GetAllCommand) {
                    GetAllCommand getAllCmd = (GetAllCommand)command;
                    List<Entry> entries = getAllCmd.revision() == -1L ? this.storage.getAll(ByteUtils.toByteArrayList(getAllCmd.keys())) : this.storage.getAll(ByteUtils.toByteArrayList(getAllCmd.keys()), getAllCmd.revision());
                    clo.result((Serializable)((Object)entries));
                    continue;
                }
                if (command instanceof GetRangeCommand) {
                    GetRangeCommand rangeCmd = (GetRangeCommand)command;
                    previousKey = rangeCmd.previousKey();
                    byte[] keyFrom = previousKey == null ? ByteUtils.toByteArray((ByteBuffer)rangeCmd.keyFrom()) : Objects.requireNonNull(this.storage.nextKey(previousKey));
                    byte @Nullable [] keyTo = rangeCmd.keyTo() == null ? null : ByteUtils.toByteArray((ByteBuffer)rangeCmd.keyTo());
                    clo.result((Serializable)this.handlePaginationCommand(keyFrom, keyTo, rangeCmd));
                    continue;
                }
                if (command instanceof GetPrefixCommand) {
                    GetPrefixCommand prefixCmd = (GetPrefixCommand)command;
                    previousKey = prefixCmd.previousKey();
                    byte[] prefix = ByteUtils.toByteArray((ByteBuffer)prefixCmd.prefix());
                    byte[] keyFrom = previousKey == null ? prefix : Objects.requireNonNull(this.storage.nextKey(previousKey));
                    byte[] keyTo = this.storage.nextKey(prefix);
                    clo.result((Serializable)this.handlePaginationCommand(keyFrom, keyTo, prefixCmd));
                    continue;
                }
                if (command instanceof GetCurrentRevisionsCommand) {
                    Revisions currentRevisions = this.storage.revisions();
                    clo.result((Serializable)RevisionsInfo.of(currentRevisions));
                    continue;
                }
                if (command instanceof GetChecksumCommand) {
                    ChecksumAndRevisions checksumInfo = this.storage.checksumAndRevisions(((GetChecksumCommand)command).revision());
                    clo.result((Serializable)new ChecksumInfo(checksumInfo.checksum(), checksumInfo.minChecksummedRevision(), checksumInfo.maxChecksummedRevision()));
                    continue;
                }
                assert (false) : "Command was not found [cmd=" + command + "]";
            }
            catch (Exception e) {
                clo.result((Serializable)e);
            }
        }
    }

    private BatchResponse handlePaginationCommand(byte[] keyFrom, byte @Nullable [] keyTo, PaginationCommand command) {
        Cursor<Entry> cursor;
        assert (command.batchSize() > 0) : command.batchSize();
        try (Cursor<Entry> cursor2 = cursor = command.revUpperBound() == -1L ? this.storage.range(keyFrom, keyTo) : this.storage.range(keyFrom, keyTo, command.revUpperBound());){
            ArrayList<Entry> entries = new ArrayList<Entry>();
            for (Entry entry : cursor) {
                if (!command.includeTombstones() && entry.tombstone()) continue;
                entries.add(entry);
                if (entries.size() != command.batchSize()) continue;
                break;
            }
            BatchResponse batchResponse = new BatchResponse(entries, cursor.hasNext());
            return batchResponse;
        }
    }

    public void onWrite(Iterator<CommandClosure<WriteCommand>> iter) {
        iter.forEachRemaining(this.writeHandler::handleWriteCommand);
    }

    public boolean onBeforeApply(Command command) {
        return this.writeHandler.beforeApply(command);
    }

    public void onConfigurationCommitted(RaftGroupConfiguration config, long lastAppliedIndex, long lastAppliedTerm) {
        this.storage.saveConfiguration(this.configurationConverter.toBytes(config), lastAppliedIndex, lastAppliedTerm);
        this.onConfigurationCommitted.accept(config);
    }

    public void onSnapshotSave(Path path, Consumer<Throwable> doneClo) {
        this.storage.snapshot(path).whenComplete((unused, throwable) -> doneClo.accept((Throwable)throwable));
    }

    public boolean onSnapshotLoad(Path path) {
        if (!path.toString().isEmpty()) {
            this.storage.restoreSnapshot(path);
        }
        this.writeHandler.onSnapshotLoad();
        return true;
    }

    public void onShutdown() {
        this.busyLock.block();
    }
}

