/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.command;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.metastorage.command.RemoveAllCommand;
import org.apache.ignite.internal.metastorage.command.RemoveAllCommandBuilder;
import org.apache.ignite.internal.metastorage.command.RemoveAllCommandSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteStringifier;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tostring.SizeOnlyStringifier;

public class RemoveAllCommandImpl
implements RemoveAllCommand,
Cloneable {
    public static final short GROUP_TYPE = 111;
    public static final short TYPE = 51;
    @IgniteToStringInclude
    private final HybridTimestamp initiatorTime;
    @IgniteStringifier(name="keys.size", value=SizeOnlyStringifier.class)
    private final List<ByteBuffer> keys;
    @IgniteToStringInclude
    private HybridTimestamp safeTime;

    private RemoveAllCommandImpl(HybridTimestamp initiatorTime, List<ByteBuffer> keys, HybridTimestamp safeTime) {
        this.initiatorTime = initiatorTime;
        this.keys = keys;
        this.safeTime = safeTime;
    }

    @Override
    public HybridTimestamp initiatorTime() {
        return this.initiatorTime;
    }

    @Override
    public List<ByteBuffer> keys() {
        return this.keys;
    }

    @Override
    public void safeTime(HybridTimestamp safeTime) {
        this.safeTime = safeTime;
    }

    @Override
    public HybridTimestamp safeTime() {
        return this.safeTime;
    }

    public MessageSerializer serializer() {
        return RemoveAllCommandSerializer.INSTANCE;
    }

    public short groupType() {
        return 111;
    }

    public String toString() {
        return S.toString(RemoveAllCommandImpl.class, (Object)this);
    }

    public short messageType() {
        return 51;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RemoveAllCommandImpl otherMessage = (RemoveAllCommandImpl)other;
        return Objects.equals(this.initiatorTime, otherMessage.initiatorTime) && Objects.equals(this.keys, otherMessage.keys) && Objects.equals(this.safeTime, otherMessage.safeTime);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.initiatorTime, this.keys, this.safeTime);
        return result;
    }

    public RemoveAllCommandImpl clone() {
        try {
            return (RemoveAllCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static RemoveAllCommandBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements RemoveAllCommandBuilder {
        private HybridTimestamp initiatorTime;
        private List<ByteBuffer> keys;
        private HybridTimestamp safeTime;

        private Builder() {
        }

        @Override
        public RemoveAllCommandBuilder initiatorTime(HybridTimestamp initiatorTime) {
            Objects.requireNonNull(initiatorTime, "initiatorTime is not marked @Nullable");
            this.initiatorTime = initiatorTime;
            return this;
        }

        @Override
        public RemoveAllCommandBuilder keys(List<ByteBuffer> keys) {
            Objects.requireNonNull(keys, "keys is not marked @Nullable");
            this.keys = keys;
            return this;
        }

        @Override
        public RemoveAllCommandBuilder safeTime(HybridTimestamp safeTime) {
            this.safeTime = safeTime;
            return this;
        }

        @Override
        public HybridTimestamp initiatorTime() {
            return this.initiatorTime;
        }

        @Override
        public List<ByteBuffer> keys() {
            return this.keys;
        }

        @Override
        public HybridTimestamp safeTime() {
            return this.safeTime;
        }

        @Override
        public RemoveAllCommand build() {
            return new RemoveAllCommandImpl(Objects.requireNonNull(this.initiatorTime, "initiatorTime is not marked @Nullable"), Objects.requireNonNull(this.keys, "keys is not marked @Nullable"), this.safeTime);
        }

        @Override
        public RemoveAllCommand buildDeserialized() {
            return new RemoveAllCommandImpl(this.initiatorTime, this.keys, this.safeTime);
        }
    }
}

