/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.command;

import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.metastorage.command.SyncTimeCommand;
import org.apache.ignite.internal.metastorage.command.SyncTimeCommandBuilder;
import org.apache.ignite.internal.metastorage.command.SyncTimeCommandSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class SyncTimeCommandImpl
implements SyncTimeCommand,
Cloneable {
    public static final short GROUP_TYPE = 111;
    public static final short TYPE = 70;
    @IgniteToStringInclude
    private final long initiatorTerm;
    @IgniteToStringInclude
    private final HybridTimestamp initiatorTime;
    @IgniteToStringInclude
    private HybridTimestamp safeTime;

    private SyncTimeCommandImpl(long initiatorTerm, HybridTimestamp initiatorTime, HybridTimestamp safeTime) {
        this.initiatorTerm = initiatorTerm;
        this.initiatorTime = initiatorTime;
        this.safeTime = safeTime;
    }

    @Override
    public long initiatorTerm() {
        return this.initiatorTerm;
    }

    @Override
    public HybridTimestamp initiatorTime() {
        return this.initiatorTime;
    }

    @Override
    public void safeTime(HybridTimestamp safeTime) {
        this.safeTime = safeTime;
    }

    @Override
    public HybridTimestamp safeTime() {
        return this.safeTime;
    }

    public MessageSerializer serializer() {
        return SyncTimeCommandSerializer.INSTANCE;
    }

    public short groupType() {
        return 111;
    }

    public String toString() {
        return S.toString(SyncTimeCommandImpl.class, (Object)this);
    }

    public short messageType() {
        return 70;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SyncTimeCommandImpl otherMessage = (SyncTimeCommandImpl)other;
        return Objects.equals(this.initiatorTime, otherMessage.initiatorTime) && Objects.equals(this.safeTime, otherMessage.safeTime) && this.initiatorTerm == otherMessage.initiatorTerm;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.initiatorTerm, this.initiatorTime, this.safeTime);
        return result;
    }

    public SyncTimeCommandImpl clone() {
        try {
            return (SyncTimeCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static SyncTimeCommandBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements SyncTimeCommandBuilder {
        private long initiatorTerm;
        private HybridTimestamp initiatorTime;
        private HybridTimestamp safeTime;

        private Builder() {
        }

        @Override
        public SyncTimeCommandBuilder initiatorTerm(long initiatorTerm) {
            this.initiatorTerm = initiatorTerm;
            return this;
        }

        @Override
        public SyncTimeCommandBuilder initiatorTime(HybridTimestamp initiatorTime) {
            Objects.requireNonNull(initiatorTime, "initiatorTime is not marked @Nullable");
            this.initiatorTime = initiatorTime;
            return this;
        }

        @Override
        public SyncTimeCommandBuilder safeTime(HybridTimestamp safeTime) {
            this.safeTime = safeTime;
            return this;
        }

        @Override
        public long initiatorTerm() {
            return this.initiatorTerm;
        }

        @Override
        public HybridTimestamp initiatorTime() {
            return this.initiatorTime;
        }

        @Override
        public HybridTimestamp safeTime() {
            return this.safeTime;
        }

        @Override
        public SyncTimeCommand build() {
            return new SyncTimeCommandImpl(this.initiatorTerm, Objects.requireNonNull(this.initiatorTime, "initiatorTime is not marked @Nullable"), this.safeTime);
        }

        @Override
        public SyncTimeCommand buildDeserialized() {
            return new SyncTimeCommandImpl(this.initiatorTerm, this.initiatorTime, this.safeTime);
        }
    }
}

