/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.command;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.metastorage.command.MetaStorageCommandsFactory;
import org.apache.ignite.internal.metastorage.command.MetaStorageCommandsTypeInfos;
import org.apache.ignite.internal.metastorage.command.PutCommand;
import org.apache.ignite.internal.metastorage.command.PutCommandBuilder;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class PutCommandDeserializer
implements MessageDeserializer<PutCommand> {
    private final PutCommandBuilder msg;

    PutCommandDeserializer(MetaStorageCommandsFactory messageFactory) {
        this.msg = messageFactory.putCommand();
    }

    public Class<PutCommand> klass() {
        return PutCommand.class;
    }

    public PutCommand getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(MetaStorageCommandsTypeInfos.putCommand());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readHybridTimestamp("initiatorTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.initiatorTime((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readByteBuffer("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.key((ByteBuffer)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readHybridTimestamp("safeTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.safeTime((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readByteBuffer("value");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.value((ByteBuffer)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(PutCommand.class);
    }
}

