/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.dsl;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.metastorage.dsl.CompoundCondition;
import org.apache.ignite.internal.metastorage.dsl.CompoundConditionBuilder;
import org.apache.ignite.internal.metastorage.dsl.CompoundConditionSerializer;
import org.apache.ignite.internal.metastorage.dsl.CompoundConditionType;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class CompoundConditionImpl
implements CompoundCondition,
Cloneable {
    public static final short GROUP_TYPE = 222;
    public static final short TYPE = 4;
    @IgniteToStringInclude
    private final Condition leftCondition;
    @IgniteToStringInclude
    private final Condition rightCondition;
    @IgniteToStringInclude
    private final CompoundConditionType type;

    private CompoundConditionImpl(Condition leftCondition, Condition rightCondition, CompoundConditionType type) {
        this.leftCondition = leftCondition;
        this.rightCondition = rightCondition;
        this.type = type;
    }

    @Override
    public Condition leftCondition() {
        return this.leftCondition;
    }

    @Override
    public Condition rightCondition() {
        return this.rightCondition;
    }

    @Override
    public CompoundConditionType type() {
        return this.type;
    }

    public MessageSerializer serializer() {
        return CompoundConditionSerializer.INSTANCE;
    }

    public short groupType() {
        return 222;
    }

    public String toString() {
        return S.toString(CompoundConditionImpl.class, (Object)this);
    }

    public short messageType() {
        return 4;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CompoundConditionImpl otherMessage = (CompoundConditionImpl)other;
        return Objects.equals(this.leftCondition, otherMessage.leftCondition) && Objects.equals(this.rightCondition, otherMessage.rightCondition) && Objects.equals((Object)this.type, (Object)otherMessage.type);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(new Object[]{this.leftCondition, this.rightCondition, this.type});
        return result;
    }

    public CompoundConditionImpl clone() {
        try {
            return (CompoundConditionImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static CompoundConditionBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.leftCondition != null) {
            this.leftCondition.prepareMarshal(usedDescriptors, marshaller);
        }
        if (this.rightCondition != null) {
            this.rightCondition.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.leftCondition != null) {
            this.leftCondition.unmarshal(marshaller, descriptorsObj);
        }
        if (this.rightCondition != null) {
            this.rightCondition.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements CompoundConditionBuilder {
        private Condition leftCondition;
        private Condition rightCondition;
        private CompoundConditionType type;

        private Builder() {
        }

        @Override
        public CompoundConditionBuilder leftCondition(Condition leftCondition) {
            Objects.requireNonNull(leftCondition, "leftCondition is not marked @Nullable");
            this.leftCondition = leftCondition;
            return this;
        }

        @Override
        public CompoundConditionBuilder rightCondition(Condition rightCondition) {
            Objects.requireNonNull(rightCondition, "rightCondition is not marked @Nullable");
            this.rightCondition = rightCondition;
            return this;
        }

        @Override
        public CompoundConditionBuilder type(CompoundConditionType type) {
            Objects.requireNonNull(type, "type is not marked @Nullable");
            this.type = type;
            return this;
        }

        @Override
        public Condition leftCondition() {
            return this.leftCondition;
        }

        @Override
        public Condition rightCondition() {
            return this.rightCondition;
        }

        @Override
        public CompoundConditionType type() {
            return this.type;
        }

        @Override
        public CompoundCondition build() {
            return new CompoundConditionImpl(Objects.requireNonNull(this.leftCondition, "leftCondition is not marked @Nullable"), Objects.requireNonNull(this.rightCondition, "rightCondition is not marked @Nullable"), Objects.requireNonNull(this.type, "type is not marked @Nullable"));
        }

        @Override
        public CompoundCondition buildDeserialized() {
            return new CompoundConditionImpl(this.leftCondition, this.rightCondition, this.type);
        }
    }
}

