/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.dsl;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.metastorage.dsl.MetaStorageMessagesFactory;
import org.apache.ignite.internal.metastorage.dsl.MetaStorageMessagesTypeInfos;
import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.metastorage.dsl.OperationBuilder;
import org.apache.ignite.internal.metastorage.dsl.OperationType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class OperationDeserializer
implements MessageDeserializer<Operation> {
    private final OperationBuilder msg;

    OperationDeserializer(MetaStorageMessagesFactory messageFactory) {
        this.msg = messageFactory.operation();
    }

    public Class<Operation> klass() {
        return Operation.class;
    }

    public Operation getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(MetaStorageMessagesTypeInfos.operation());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                ByteBuffer tmp = reader.readByteBuffer("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.key(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                OperationType tmp;
                int shiftedId = reader.readInt("type");
                if (!reader.isLastRead()) {
                    return false;
                }
                OperationType operationType = tmp = shiftedId == 0 ? null : OperationType.fromId(shiftedId - 1);
                if (tmp != null) {
                    this.msg.type(tmp);
                }
                reader.incrementState();
            }
            case 2: {
                ByteBuffer tmp = reader.readByteBuffer("value");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.value(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(Operation.class);
    }
}

