/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.mesos.resource;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class IgniteProvider {
    private static final Logger log = Logger.getLogger(IgniteProvider.class.getSimpleName());
    private static final String DOWNLOAD_URL_PATTERN = "https://archive.apache.org/dist/ignite/%s/apache-ignite-%s-bin.zip";
    private static final String IGNITE_LATEST_VERSION_URL = "https://ignite.apache.org/latest";
    private static final String APACHE_MIRROR_URL = "https://www.apache.org/dyn/closer.cgi?as_json=1";
    private static final String IGNITE_PATH = "/ignite/%s/apache-ignite-%s-bin.zip";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(?<=version=).*\\S+");
    private String downloadFolder;

    public IgniteProvider(String downloadFolder) {
        this.downloadFolder = downloadFolder;
    }

    public String getIgnite(String ver) throws IOException {
        return this.downloadIgnite(ver);
    }

    public String downloadIgnite(String ver) throws IOException {
        URL url;
        assert (ver != null);
        if (ver.equals("latest")) {
            try {
                ver = this.findLatestVersion();
                url = new URL(String.format(this.findMirror() + IGNITE_PATH, ver, ver));
            }
            catch (Exception e) {
                url = new URL(String.format(DOWNLOAD_URL_PATTERN, ver, ver));
            }
        } else {
            url = new URL(String.format(DOWNLOAD_URL_PATTERN, ver, ver));
        }
        return this.downloadIgnite(url);
    }

    private String findMirror() throws IOException {
        String response = this.getHttpContents(new URL(APACHE_MIRROR_URL));
        if (response == null) {
            throw new RuntimeException("Failed to retrieve mirrors");
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode mirrorUrl = mapper.readTree(response).get("preferred");
        if (mirrorUrl == null) {
            throw new RuntimeException("Failed to find the preferred mirror");
        }
        return mirrorUrl.asText();
    }

    private String findLatestVersion() throws IOException {
        String response = this.getHttpContents(new URL(IGNITE_LATEST_VERSION_URL));
        if (response == null) {
            throw new RuntimeException("Failed to identify the latest version. Specify it with IGNITE_VERSION");
        }
        Matcher m = VERSION_PATTERN.matcher(response);
        if (m.find()) {
            return m.group();
        }
        throw new RuntimeException("Failed to retrieve the latest version. Specify it with IGNITE_VERSION");
    }

    private String getHttpContents(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        int code = conn.getResponseCode();
        if (code != 200) {
            throw null;
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
        return rd.lines().collect(Collectors.joining());
    }

    private String downloadIgnite(URL url) {
        assert (url != null);
        try {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            int code = conn.getResponseCode();
            if (code == 200) {
                this.checkDownloadFolder();
                String fileName = IgniteProvider.fileName(url.toString());
                if (this.fileExist(fileName)) {
                    return fileName;
                }
                log.log(Level.INFO, "Downloading from {0}", url.toString());
                FileOutputStream outFile = new FileOutputStream(Paths.get(this.downloadFolder, fileName).toFile());
                outFile.getChannel().transferFrom(Channels.newChannel(conn.getInputStream()), 0L, Long.MAX_VALUE);
                outFile.close();
                return fileName;
            }
            throw new RuntimeException("Got unexpected response code. Response code: " + code + " from " + url);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to download Ignite.", e);
        }
    }

    private boolean fileExist(String fileName) {
        String pathToIgnite = this.downloadFolder + (this.downloadFolder.endsWith("/") ? "" : Character.valueOf('/')) + fileName;
        return new File(pathToIgnite).exists();
    }

    String copyToWorkDir(String filePath) throws IOException {
        Path srcFile = Paths.get(filePath, new String[0]);
        if (Files.exists(srcFile, new LinkOption[0])) {
            this.checkDownloadFolder();
            Path newDir = Paths.get(this.downloadFolder, new String[0]);
            Path fileName = srcFile.getFileName();
            Files.copy(srcFile, newDir.resolve(fileName), StandardCopyOption.REPLACE_EXISTING);
            return fileName.toString();
        }
        return null;
    }

    private File checkDownloadFolder() {
        File file = new File(this.downloadFolder);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("Failed to create working directory: " + this.downloadFolder);
        }
        return file;
    }

    private static String fileName(String url) {
        String[] split = url.split("/");
        return split[split.length - 1];
    }
}

