/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.mesos.resource;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ignite.mesos.ClusterProperties;
import org.apache.ignite.mesos.resource.IgniteProvider;

public class ResourceProvider {
    private static final Logger log = Logger.getLogger(ResourceProvider.class.getSimpleName());
    private String igniteUrl;
    private Collection<String> libsUris;
    private String cfgUrl;
    private String cfgName;

    public void init(ClusterProperties props, IgniteProvider provider, String baseUrl) throws IOException {
        if (props.ignitePackageUrl() == null && props.ignitePackagePath() == null) {
            try {
                this.igniteUrl = baseUrl + "/ignite/" + provider.getIgnite(props.igniteVer());
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to download Ignite [err={0}, ver={1}].\nIf application working behind NAT or Intranet and does not have access to external resources then you can use IGNITE_PACKAGE_URL or IGNITE_PACKAGE_PATH property that allow to use local resources.", new Object[]{e, props.igniteVer()});
            }
        }
        if (props.ignitePackagePath() != null) {
            Path ignitePackPath = Paths.get(props.ignitePackagePath(), new String[0]);
            if (Files.exists(ignitePackPath, new LinkOption[0]) && !Files.isDirectory(ignitePackPath, new LinkOption[0])) {
                try {
                    String fileName = provider.copyToWorkDir(props.ignitePackagePath());
                    assert (fileName != null);
                    this.igniteUrl = baseUrl + "/ignite/" + fileName;
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Failed to copy Ignite to working directory [err={0}, path={1}].", new Object[]{e, props.ignitePackagePath()});
                    throw e;
                }
            } else {
                throw new IllegalArgumentException("Failed to find a ignite archive by path: " + props.ignitePackagePath());
            }
        }
        if (props.userLibs() != null && !props.userLibs().isEmpty()) {
            File[] files;
            File libsDir = new File(props.userLibs());
            ArrayList<String> libs = new ArrayList<String>();
            if (libsDir.isDirectory() && (files = libsDir.listFiles()) != null) {
                for (File lib : files) {
                    if (!lib.isFile() || !lib.canRead() || !lib.getName().endsWith(".jar") && !lib.getName().endsWith(".JAR")) continue;
                    libs.add(baseUrl + "/libs/" + lib.getName());
                }
            }
            Collection<String> collection = this.libsUris = libs.isEmpty() ? null : libs;
        }
        if (props.igniteCfg() != null) {
            File cfg = new File(props.igniteCfg());
            if (cfg.isFile() && cfg.canRead()) {
                this.cfgUrl = baseUrl + "/config/" + cfg.getName();
                this.cfgName = cfg.getName();
            }
        } else {
            this.cfgName = "ignite-default-config.xml";
            this.cfgUrl = baseUrl + "/config/default/" + this.cfgName;
        }
    }

    public String configName() {
        return this.cfgName;
    }

    public String igniteUrl() {
        return this.igniteUrl;
    }

    public Collection<String> resourceUrl() {
        return this.libsUris;
    }

    public String igniteConfigUrl() {
        return this.cfgUrl;
    }
}

