/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.mesos.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class ResourceHandler
extends AbstractHandler {
    public static final String IGNITE_PREFIX = "/ignite/";
    public static final String LIBS_PREFIX = "/libs/";
    public static final String CONFIG_PREFIX = "/config/";
    public static final String DEFAULT_CONFIG = "/config/default/";
    private String libsDir;
    private String cfgPath;
    private String igniteDir;

    public ResourceHandler(String libsDir, String cfgPath, String igniteDir) {
        this.libsDir = libsDir;
        this.cfgPath = cfgPath;
        this.igniteDir = igniteDir;
    }

    @Override
    public void handle(String url, Request request, HttpServletRequest httpServletRequest, HttpServletResponse response) throws IOException, ServletException {
        String servicePath;
        String[] path = url.split("/");
        String fileName = path[path.length - 1];
        switch (servicePath = url.substring(0, url.length() - fileName.length())) {
            case "/ignite/": {
                ResourceHandler.handleRequest(response, "application/zip-archive", this.igniteDir + "/" + fileName);
                request.setHandled(true);
                break;
            }
            case "/libs/": {
                ResourceHandler.handleRequest(response, "application/java-archive", this.libsDir + "/" + fileName);
                request.setHandled(true);
                break;
            }
            case "/config/": {
                ResourceHandler.handleRequest(response, "application/xml", this.cfgPath);
                request.setHandled(true);
                break;
            }
            case "/config/default/": {
                ResourceHandler.handleRequest(response, "application/xml", Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName), fileName);
                request.setHandled(true);
            }
        }
    }

    private static void handleRequest(HttpServletResponse response, String type, String path) throws IOException {
        Path path0 = Paths.get(path, new String[0]);
        response.setContentType(type);
        response.setHeader("Content-Disposition", "attachment; filename=\"" + path0.getFileName() + "\"");
        try (HttpOutput out = (HttpOutput)response.getOutputStream();){
            out.sendContent(FileChannel.open(path0, StandardOpenOption.READ));
        }
    }

    private static void handleRequest(HttpServletResponse response, String type, InputStream stream, String attachmentName) throws IOException {
        response.setContentType(type);
        response.setHeader("Content-Disposition", "attachment; filename=\"" + attachmentName + "\"");
        try (HttpOutput out = (HttpOutput)response.getOutputStream();){
            out.sendContent(stream);
        }
    }
}

