/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.marshaller;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import org.apache.ignite.internal.marshaller.Creator;
import org.apache.ignite.internal.marshaller.FieldAccessor;
import org.apache.ignite.internal.marshaller.MarshallerReader;
import org.apache.ignite.lang.MarshallerException;

class CreatorFromAnnotatedFieldsWithDefaultConstructor
implements Creator {
    private final MethodHandle mhNoArgs;

    CreatorFromAnnotatedFieldsWithDefaultConstructor(Constructor<?> defaultCtor) {
        assert (defaultCtor.getParameterCount() == 0);
        this.mhNoArgs = CreatorFromAnnotatedFieldsWithDefaultConstructor.unreflect(defaultCtor);
    }

    @Override
    public Object createInstance(FieldAccessor[] accessors, MarshallerReader reader) {
        try {
            Object instance = this.mhNoArgs.invokeExact();
            for (int fldIdx = 0; fldIdx < accessors.length; ++fldIdx) {
                accessors[fldIdx].read(reader, instance);
            }
            return instance;
        }
        catch (MarshallerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Failed to instantiate class", e);
        }
    }

    private static MethodHandle unreflect(Constructor<?> defaultCtor) {
        try {
            defaultCtor.setAccessible(true);
            return MethodHandles.lookup().unreflectConstructor(defaultCtor).asType(MethodType.methodType(Object.class));
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to create method handle from constructor", e);
        }
    }
}

