/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.marshaller;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.ignite.internal.marshaller.CreatorFromAnnotatedConstructorParameters;
import org.apache.ignite.internal.marshaller.CreatorFromAnnotatedFieldsWithDefaultConstructor;
import org.apache.ignite.internal.marshaller.FieldAccessor;
import org.apache.ignite.internal.marshaller.MarshallerReader;
import org.apache.ignite.table.mapper.RecordSupportInternal;

@FunctionalInterface
interface Creator {
    public Object createInstance(FieldAccessor[] var1, MarshallerReader var2);

    public static Creator of(Class<?> clazz) {
        try {
            if (RecordSupportInternal.isRecord(clazz)) {
                Constructor<?> canonicalCtor = RecordSupportInternal.getCanonicalConstructor(clazz);
                return new CreatorFromAnnotatedConstructorParameters(canonicalCtor);
            }
            Constructor<?> defaultCtor = clazz.getDeclaredConstructor(new Class[0]);
            return new CreatorFromAnnotatedFieldsWithDefaultConstructor(defaultCtor);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IllegalArgumentException("Could not find default (no-args) or canonical (record) constructor for " + clazz, ex);
        }
    }
}

