/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.processors.query.h2.opt;

import java.io.EOFException;
import java.io.IOException;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeMemory;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.IndexInput;
import org.gridgain.internal.processors.query.h2.opt.GridLuceneFile;

public class GridLuceneInputStream
extends IndexInput
implements Cloneable {
    private GridLuceneFile file;
    private long length;
    private long currBuf;
    private int currBufIdx;
    private int bufPosition;
    private long bufStart;
    private int bufLength;
    private final GridUnsafeMemory mem;
    private volatile boolean closed;
    private boolean isClone;

    public GridLuceneInputStream(String name, GridLuceneFile f) throws IOException {
        this(name, f, f.getLength());
    }

    public GridLuceneInputStream(String name, GridLuceneFile f, long length) throws IOException {
        super("RAMInputStream(name=" + name + ")");
        this.file = f;
        this.length = length;
        if (length / 32768L >= Integer.MAX_VALUE) {
            throw new IOException("RAMInputStream too large length=" + length + ": " + name);
        }
        this.mem = this.file.getDirectory().memory();
        this.currBufIdx = -1;
        this.currBuf = 0L;
    }

    public void close() {
        if (!this.isClone) {
            this.closed = true;
            this.file.releaseRef();
        }
    }

    public IndexInput clone() {
        GridLuceneInputStream clone = (GridLuceneInputStream)super.clone();
        if (this.closed) {
            throw new AlreadyClosedException(this.toString());
        }
        clone.isClone = true;
        return clone;
    }

    public long length() {
        return this.length;
    }

    public byte readByte() throws IOException {
        if (this.bufPosition >= this.bufLength) {
            ++this.currBufIdx;
            this.switchCurrentBuffer(true);
        }
        return this.mem.readByte(this.currBuf + (long)this.bufPosition++);
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        while (len > 0) {
            int remainInBuf;
            if (this.bufPosition >= this.bufLength) {
                ++this.currBufIdx;
                this.switchCurrentBuffer(true);
            }
            int bytesToCp = len < (remainInBuf = this.bufLength - this.bufPosition) ? len : remainInBuf;
            this.mem.readBytes(this.currBuf + (long)this.bufPosition, b, offset, bytesToCp);
            offset += bytesToCp;
            len -= bytesToCp;
            this.bufPosition += bytesToCp;
        }
    }

    private void switchCurrentBuffer(boolean enforceEOF) throws IOException {
        this.bufStart = 32768L * (long)this.currBufIdx;
        if (this.currBufIdx >= this.file.numBuffers()) {
            if (enforceEOF) {
                throw new EOFException("read past EOF: " + this);
            }
            --this.currBufIdx;
            this.bufPosition = 32768;
        } else {
            this.currBuf = this.file.getBuffer(this.currBufIdx);
            this.bufPosition = 0;
            long buflen = this.length - this.bufStart;
            this.bufLength = buflen > 32768L ? 32768 : (int)buflen;
        }
    }

    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        if (offset < 0L || length < 0L || offset + length > this.length) {
            throw new IllegalArgumentException("slice() " + sliceDescription + " out of bounds: " + this);
        }
        String newResourceDescription = sliceDescription == null ? this.toString() : this.toString() + " [slice=" + sliceDescription + "]";
        return new SlicedInputStream(newResourceDescription, offset, length);
    }

    void readBytes(long ptr, int len) throws IOException {
        while (len > 0) {
            int remainInBuf;
            if (this.bufPosition >= this.bufLength) {
                ++this.currBufIdx;
                this.switchCurrentBuffer(true);
            }
            int bytesToCp = len < (remainInBuf = this.bufLength - this.bufPosition) ? len : remainInBuf;
            this.mem.copyMemory(this.currBuf + (long)this.bufPosition, ptr, (long)bytesToCp);
            ptr += (long)bytesToCp;
            len -= bytesToCp;
            this.bufPosition += bytesToCp;
        }
    }

    public long getFilePointer() {
        return this.currBufIdx < 0 ? 0L : this.bufStart + (long)this.bufPosition;
    }

    public void seek(long pos) throws IOException {
        if (this.currBuf == 0L || pos < this.bufStart || pos >= this.bufStart + 32768L) {
            this.currBufIdx = (int)(pos / 32768L);
            this.switchCurrentBuffer(false);
        }
        this.bufPosition = (int)(pos % 32768L);
    }

    private class SlicedInputStream
    extends GridLuceneInputStream {
        private final long offset;

        public SlicedInputStream(String newResourceDescription, long offset, long length) throws IOException {
            super(newResourceDescription, GridLuceneInputStream.this.file, offset + length);
            this.isClone = true;
            this.offset = offset;
            this.seek(0L);
        }

        @Override
        public void seek(long pos) throws IOException {
            if (pos < 0L) {
                throw new IllegalArgumentException("Seeking to negative position: " + this);
            }
            super.seek(pos + this.offset);
        }

        @Override
        public long getFilePointer() {
            return super.getFilePointer() - this.offset;
        }

        @Override
        public long length() {
            return super.length() - this.offset;
        }

        @Override
        public IndexInput slice(String sliceDescription, long ofs, long len) throws IOException {
            return super.slice(sliceDescription, this.offset + ofs, len);
        }
    }
}

